/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.builtin;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import org.eclipse.milo.opcua.stack.core.StatusCodes;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;

public final class StatusCode {
    private static final long SEVERITY_MASK = 0xC0000000L;
    private static final long SEVERITY_GOOD = 0L;
    private static final long SEVERITY_UNCERTAIN = 0x40000000L;
    private static final long SEVERITY_BAD = 0x80000000L;
    private static final ImmutableSet<Long> SECURITY_ERRORS = ImmutableSet.builder().add((Object[])new Long[]{2153185280L, 2149515264L, 0x80550000L, 2152988672L, 2148728832L, 0x80870000L, 0x80220000L, 2153316352L, 0x80200000L, 2149646336L, 2160459776L, 0x80180000L, 2148990976L, 2149187584L, 2148794368L, 2149384192L, 2149253120L, 2149122048L, 2148859904L, 2149449728L, 2149318656L, 2148663296L, 2148925440L, 0x80580000L}).build();
    public static final StatusCode GOOD = new StatusCode(0L);
    public static final StatusCode BAD = new StatusCode(0x80000000L);
    public static final StatusCode UNCERTAIN = new StatusCode(0x40000000L);
    private final long value;

    public StatusCode(int value) {
        this.value = (long)value & 0xFFFFFFFFL;
    }

    public StatusCode(long value) {
        this.value = value & 0xFFFFFFFFL;
    }

    public StatusCode(UInteger value) {
        this(value.longValue());
    }

    public long getValue() {
        return this.value;
    }

    public boolean isGood() {
        return (this.value & 0xC0000000L) == 0L;
    }

    public boolean isBad() {
        return (this.value & 0xC0000000L) == 0x80000000L;
    }

    public boolean isUncertain() {
        return (this.value & 0xC0000000L) == 0x40000000L;
    }

    public StatusCode withOverflow() {
        return new StatusCode(this.value | 0x480L);
    }

    public StatusCode withoutOverflow() {
        return new StatusCode(this.value & 0xFFFFFFFFFFFFFB7FL);
    }

    public boolean isOverflowSet() {
        return (this.value & 0x480L) == 1152L;
    }

    public boolean isSecurityError() {
        return SECURITY_ERRORS.contains((Object)this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatusCode that = (StatusCode)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this);
        StatusCodes.lookup(this.value).ifPresent(nameAndDesc -> {
            MoreObjects.ToStringHelper toStringHelper2 = helper.add("name", (Object)nameAndDesc[0]);
        });
        helper.add("value", (Object)String.format("0x%08X", this.value));
        helper.add("quality", (Object)StatusCode.quality(this));
        return helper.toString();
    }

    private static String quality(StatusCode statusCode) {
        if (statusCode.isGood()) {
            return "good";
        }
        if (statusCode.isBad()) {
            return "bad";
        }
        if (statusCode.isUncertain()) {
            return "uncertain";
        }
        return "unknown";
    }
}

