/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.RelativePath;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class BrowsePath
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=543");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=545");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=544");
    public static final ExpandedNodeId JSON_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=15190");
    private final NodeId startingNode;
    private final RelativePath relativePath;

    public BrowsePath(NodeId startingNode, RelativePath relativePath) {
        this.startingNode = startingNode;
        this.relativePath = relativePath;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public NodeId getStartingNode() {
        return this.startingNode;
    }

    public RelativePath getRelativePath() {
        return this.relativePath;
    }

    public static final class Codec
    extends GenericDataTypeCodec<BrowsePath> {
        @Override
        public Class<BrowsePath> getType() {
            return BrowsePath.class;
        }

        @Override
        public BrowsePath decode(SerializationContext context, UaDecoder decoder) {
            NodeId startingNode = decoder.readNodeId("StartingNode");
            RelativePath relativePath = (RelativePath)decoder.readStruct("RelativePath", RelativePath.TYPE_ID);
            return new BrowsePath(startingNode, relativePath);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, BrowsePath value) {
            encoder.writeNodeId("StartingNode", value.getStartingNode());
            encoder.writeStruct("RelativePath", (Object)value.getRelativePath(), RelativePath.TYPE_ID);
        }
    }
}

