/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemNotification;
import org.eclipse.milo.opcua.stack.core.types.structured.NotificationData;

public class DataChangeNotification
extends NotificationData
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=809");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=811");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=810");
    private final MonitoredItemNotification[] monitoredItems;
    private final DiagnosticInfo[] diagnosticInfos;

    public DataChangeNotification(MonitoredItemNotification[] monitoredItems, DiagnosticInfo[] diagnosticInfos) {
        this.monitoredItems = monitoredItems;
        this.diagnosticInfos = diagnosticInfos;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public MonitoredItemNotification[] getMonitoredItems() {
        return this.monitoredItems;
    }

    public DiagnosticInfo[] getDiagnosticInfos() {
        return this.diagnosticInfos;
    }

    public static final class Codec
    extends GenericDataTypeCodec<DataChangeNotification> {
        @Override
        public Class<DataChangeNotification> getType() {
            return DataChangeNotification.class;
        }

        @Override
        public DataChangeNotification decode(SerializationContext context, UaDecoder decoder) {
            MonitoredItemNotification[] monitoredItems = (MonitoredItemNotification[])decoder.readStructArray("MonitoredItems", MonitoredItemNotification.TYPE_ID);
            DiagnosticInfo[] diagnosticInfos = decoder.readDiagnosticInfoArray("DiagnosticInfos");
            return new DataChangeNotification(monitoredItems, diagnosticInfos);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, DataChangeNotification value) {
            encoder.writeStructArray("MonitoredItems", (Object[])value.getMonitoredItems(), MonitoredItemNotification.TYPE_ID);
            encoder.writeDiagnosticInfoArray("DiagnosticInfos", value.getDiagnosticInfos());
        }
    }
}

