/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryUpdateDetails;

public class DeleteAtTimeDetails
extends HistoryUpdateDetails
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=689");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=691");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=690");
    private final DateTime[] reqTimes;

    public DeleteAtTimeDetails(NodeId nodeId, DateTime[] reqTimes) {
        super(nodeId);
        this.reqTimes = reqTimes;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public DateTime[] getReqTimes() {
        return this.reqTimes;
    }

    public static final class Codec
    extends GenericDataTypeCodec<DeleteAtTimeDetails> {
        @Override
        public Class<DeleteAtTimeDetails> getType() {
            return DeleteAtTimeDetails.class;
        }

        @Override
        public DeleteAtTimeDetails decode(SerializationContext context, UaDecoder decoder) {
            NodeId nodeId = decoder.readNodeId("NodeId");
            DateTime[] reqTimes = decoder.readDateTimeArray("ReqTimes");
            return new DeleteAtTimeDetails(nodeId, reqTimes);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, DeleteAtTimeDetails value) {
            encoder.writeNodeId("NodeId", value.getNodeId());
            encoder.writeDateTimeArray("ReqTimes", value.getReqTimes());
        }
    }
}

