/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.structured.DataTypeDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.EnumDefinition;

public class EnumDescription
extends DataTypeDescription
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=15488");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=127");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=15590");
    public static final ExpandedNodeId JSON_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=15059");
    private final EnumDefinition enumDefinition;
    private final UByte builtInType;

    public EnumDescription(NodeId dataTypeId, QualifiedName name, EnumDefinition enumDefinition, UByte builtInType) {
        super(dataTypeId, name);
        this.enumDefinition = enumDefinition;
        this.builtInType = builtInType;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public EnumDefinition getEnumDefinition() {
        return this.enumDefinition;
    }

    public UByte getBuiltInType() {
        return this.builtInType;
    }

    public static final class Codec
    extends GenericDataTypeCodec<EnumDescription> {
        @Override
        public Class<EnumDescription> getType() {
            return EnumDescription.class;
        }

        @Override
        public EnumDescription decode(SerializationContext context, UaDecoder decoder) {
            NodeId dataTypeId = decoder.readNodeId("DataTypeId");
            QualifiedName name = decoder.readQualifiedName("Name");
            EnumDefinition enumDefinition = (EnumDefinition)decoder.readStruct("EnumDefinition", EnumDefinition.TYPE_ID);
            UByte builtInType = decoder.readByte("BuiltInType");
            return new EnumDescription(dataTypeId, name, enumDefinition, builtInType);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, EnumDescription value) {
            encoder.writeNodeId("DataTypeId", value.getDataTypeId());
            encoder.writeQualifiedName("Name", value.getName());
            encoder.writeStruct("EnumDefinition", (Object)value.getEnumDefinition(), EnumDefinition.TYPE_ID);
            encoder.writeByte("BuiltInType", value.getBuiltInType());
        }
    }
}

