/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.ServerOnNetwork;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class FindServersOnNetworkResponse
extends Structure
implements UaResponseMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=12191");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=12209");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=12197");
    private final ResponseHeader responseHeader;
    private final DateTime lastCounterResetTime;
    private final ServerOnNetwork[] servers;

    public FindServersOnNetworkResponse(ResponseHeader responseHeader, DateTime lastCounterResetTime, ServerOnNetwork[] servers) {
        this.responseHeader = responseHeader;
        this.lastCounterResetTime = lastCounterResetTime;
        this.servers = servers;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    public DateTime getLastCounterResetTime() {
        return this.lastCounterResetTime;
    }

    public ServerOnNetwork[] getServers() {
        return this.servers;
    }

    public static final class Codec
    extends GenericDataTypeCodec<FindServersOnNetworkResponse> {
        @Override
        public Class<FindServersOnNetworkResponse> getType() {
            return FindServersOnNetworkResponse.class;
        }

        @Override
        public FindServersOnNetworkResponse decode(SerializationContext context, UaDecoder decoder) {
            ResponseHeader responseHeader = (ResponseHeader)decoder.readStruct("ResponseHeader", ResponseHeader.TYPE_ID);
            DateTime lastCounterResetTime = decoder.readDateTime("LastCounterResetTime");
            ServerOnNetwork[] servers = (ServerOnNetwork[])decoder.readStructArray("Servers", ServerOnNetwork.TYPE_ID);
            return new FindServersOnNetworkResponse(responseHeader, lastCounterResetTime, servers);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, FindServersOnNetworkResponse value) {
            encoder.writeStruct("ResponseHeader", (Object)value.getResponseHeader(), ResponseHeader.TYPE_ID);
            encoder.writeDateTime("LastCounterResetTime", value.getLastCounterResetTime());
            encoder.writeStructArray("Servers", (Object[])value.getServers(), ServerOnNetwork.TYPE_ID);
        }
    }
}

