/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class HistoryReadRequest
extends Structure
implements UaRequestMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=662");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=664");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=663");
    private final RequestHeader requestHeader;
    private final ExtensionObject historyReadDetails;
    private final TimestampsToReturn timestampsToReturn;
    private final Boolean releaseContinuationPoints;
    private final HistoryReadValueId[] nodesToRead;

    public HistoryReadRequest(RequestHeader requestHeader, ExtensionObject historyReadDetails, TimestampsToReturn timestampsToReturn, Boolean releaseContinuationPoints, HistoryReadValueId[] nodesToRead) {
        this.requestHeader = requestHeader;
        this.historyReadDetails = historyReadDetails;
        this.timestampsToReturn = timestampsToReturn;
        this.releaseContinuationPoints = releaseContinuationPoints;
        this.nodesToRead = nodesToRead;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public ExtensionObject getHistoryReadDetails() {
        return this.historyReadDetails;
    }

    public TimestampsToReturn getTimestampsToReturn() {
        return this.timestampsToReturn;
    }

    public Boolean getReleaseContinuationPoints() {
        return this.releaseContinuationPoints;
    }

    public HistoryReadValueId[] getNodesToRead() {
        return this.nodesToRead;
    }

    public static final class Codec
    extends GenericDataTypeCodec<HistoryReadRequest> {
        @Override
        public Class<HistoryReadRequest> getType() {
            return HistoryReadRequest.class;
        }

        @Override
        public HistoryReadRequest decode(SerializationContext context, UaDecoder decoder) {
            RequestHeader requestHeader = (RequestHeader)decoder.readStruct("RequestHeader", RequestHeader.TYPE_ID);
            ExtensionObject historyReadDetails = decoder.readExtensionObject("HistoryReadDetails");
            TimestampsToReturn timestampsToReturn = decoder.readEnum("TimestampsToReturn", TimestampsToReturn.class);
            Boolean releaseContinuationPoints = decoder.readBoolean("ReleaseContinuationPoints");
            HistoryReadValueId[] nodesToRead = (HistoryReadValueId[])decoder.readStructArray("NodesToRead", HistoryReadValueId.TYPE_ID);
            return new HistoryReadRequest(requestHeader, historyReadDetails, timestampsToReturn, releaseContinuationPoints, nodesToRead);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, HistoryReadRequest value) {
            encoder.writeStruct("RequestHeader", (Object)value.getRequestHeader(), RequestHeader.TYPE_ID);
            encoder.writeExtensionObject("HistoryReadDetails", value.getHistoryReadDetails());
            encoder.writeEnum("TimestampsToReturn", value.getTimestampsToReturn());
            encoder.writeBoolean("ReleaseContinuationPoints", value.getReleaseContinuationPoints());
            encoder.writeStructArray("NodesToRead", (Object[])value.getNodesToRead(), HistoryReadValueId.TYPE_ID);
        }
    }
}

