/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class HistoryUpdateRequest
extends Structure
implements UaRequestMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=698");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=700");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=699");
    private final RequestHeader requestHeader;
    private final ExtensionObject[] historyUpdateDetails;

    public HistoryUpdateRequest(RequestHeader requestHeader, ExtensionObject[] historyUpdateDetails) {
        this.requestHeader = requestHeader;
        this.historyUpdateDetails = historyUpdateDetails;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public ExtensionObject[] getHistoryUpdateDetails() {
        return this.historyUpdateDetails;
    }

    public static final class Codec
    extends GenericDataTypeCodec<HistoryUpdateRequest> {
        @Override
        public Class<HistoryUpdateRequest> getType() {
            return HistoryUpdateRequest.class;
        }

        @Override
        public HistoryUpdateRequest decode(SerializationContext context, UaDecoder decoder) {
            RequestHeader requestHeader = (RequestHeader)decoder.readStruct("RequestHeader", RequestHeader.TYPE_ID);
            ExtensionObject[] historyUpdateDetails = decoder.readExtensionObjectArray("HistoryUpdateDetails");
            return new HistoryUpdateRequest(requestHeader, historyUpdateDetails);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, HistoryUpdateRequest value) {
            encoder.writeStruct("RequestHeader", (Object)value.getRequestHeader(), RequestHeader.TYPE_ID);
            encoder.writeExtensionObjectArray("HistoryUpdateDetails", value.getHistoryUpdateDetails());
        }
    }
}

