/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.ContentFilter;
import org.eclipse.milo.opcua.stack.core.types.structured.NodeTypeDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;
import org.eclipse.milo.opcua.stack.core.types.structured.ViewDescription;

public class QueryFirstRequest
extends Structure
implements UaRequestMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=613");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=615");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=614");
    private final RequestHeader requestHeader;
    private final ViewDescription view;
    private final NodeTypeDescription[] nodeTypes;
    private final ContentFilter filter;
    private final UInteger maxDataSetsToReturn;
    private final UInteger maxReferencesToReturn;

    public QueryFirstRequest(RequestHeader requestHeader, ViewDescription view, NodeTypeDescription[] nodeTypes, ContentFilter filter, UInteger maxDataSetsToReturn, UInteger maxReferencesToReturn) {
        this.requestHeader = requestHeader;
        this.view = view;
        this.nodeTypes = nodeTypes;
        this.filter = filter;
        this.maxDataSetsToReturn = maxDataSetsToReturn;
        this.maxReferencesToReturn = maxReferencesToReturn;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public ViewDescription getView() {
        return this.view;
    }

    public NodeTypeDescription[] getNodeTypes() {
        return this.nodeTypes;
    }

    public ContentFilter getFilter() {
        return this.filter;
    }

    public UInteger getMaxDataSetsToReturn() {
        return this.maxDataSetsToReturn;
    }

    public UInteger getMaxReferencesToReturn() {
        return this.maxReferencesToReturn;
    }

    public static final class Codec
    extends GenericDataTypeCodec<QueryFirstRequest> {
        @Override
        public Class<QueryFirstRequest> getType() {
            return QueryFirstRequest.class;
        }

        @Override
        public QueryFirstRequest decode(SerializationContext context, UaDecoder decoder) {
            RequestHeader requestHeader = (RequestHeader)decoder.readStruct("RequestHeader", RequestHeader.TYPE_ID);
            ViewDescription view = (ViewDescription)decoder.readStruct("View", ViewDescription.TYPE_ID);
            NodeTypeDescription[] nodeTypes = (NodeTypeDescription[])decoder.readStructArray("NodeTypes", NodeTypeDescription.TYPE_ID);
            ContentFilter filter = (ContentFilter)decoder.readStruct("Filter", ContentFilter.TYPE_ID);
            UInteger maxDataSetsToReturn = decoder.readUInt32("MaxDataSetsToReturn");
            UInteger maxReferencesToReturn = decoder.readUInt32("MaxReferencesToReturn");
            return new QueryFirstRequest(requestHeader, view, nodeTypes, filter, maxDataSetsToReturn, maxReferencesToReturn);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, QueryFirstRequest value) {
            encoder.writeStruct("RequestHeader", (Object)value.getRequestHeader(), RequestHeader.TYPE_ID);
            encoder.writeStruct("View", (Object)value.getView(), ViewDescription.TYPE_ID);
            encoder.writeStructArray("NodeTypes", (Object[])value.getNodeTypes(), NodeTypeDescription.TYPE_ID);
            encoder.writeStruct("Filter", (Object)value.getFilter(), ContentFilter.TYPE_ID);
            encoder.writeUInt32("MaxDataSetsToReturn", value.getMaxDataSetsToReturn());
            encoder.writeUInt32("MaxReferencesToReturn", value.getMaxReferencesToReturn());
        }
    }
}

