/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.ContentFilterResult;
import org.eclipse.milo.opcua.stack.core.types.structured.ParsingResult;
import org.eclipse.milo.opcua.stack.core.types.structured.QueryDataSet;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class QueryFirstResponse
extends Structure
implements UaResponseMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=616");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=618");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=617");
    private final ResponseHeader responseHeader;
    private final QueryDataSet[] queryDataSets;
    private final ByteString continuationPoint;
    private final ParsingResult[] parsingResults;
    private final DiagnosticInfo[] diagnosticInfos;
    private final ContentFilterResult filterResult;

    public QueryFirstResponse(ResponseHeader responseHeader, QueryDataSet[] queryDataSets, ByteString continuationPoint, ParsingResult[] parsingResults, DiagnosticInfo[] diagnosticInfos, ContentFilterResult filterResult) {
        this.responseHeader = responseHeader;
        this.queryDataSets = queryDataSets;
        this.continuationPoint = continuationPoint;
        this.parsingResults = parsingResults;
        this.diagnosticInfos = diagnosticInfos;
        this.filterResult = filterResult;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    public QueryDataSet[] getQueryDataSets() {
        return this.queryDataSets;
    }

    public ByteString getContinuationPoint() {
        return this.continuationPoint;
    }

    public ParsingResult[] getParsingResults() {
        return this.parsingResults;
    }

    public DiagnosticInfo[] getDiagnosticInfos() {
        return this.diagnosticInfos;
    }

    public ContentFilterResult getFilterResult() {
        return this.filterResult;
    }

    public static final class Codec
    extends GenericDataTypeCodec<QueryFirstResponse> {
        @Override
        public Class<QueryFirstResponse> getType() {
            return QueryFirstResponse.class;
        }

        @Override
        public QueryFirstResponse decode(SerializationContext context, UaDecoder decoder) {
            ResponseHeader responseHeader = (ResponseHeader)decoder.readStruct("ResponseHeader", ResponseHeader.TYPE_ID);
            QueryDataSet[] queryDataSets = (QueryDataSet[])decoder.readStructArray("QueryDataSets", QueryDataSet.TYPE_ID);
            ByteString continuationPoint = decoder.readByteString("ContinuationPoint");
            ParsingResult[] parsingResults = (ParsingResult[])decoder.readStructArray("ParsingResults", ParsingResult.TYPE_ID);
            DiagnosticInfo[] diagnosticInfos = decoder.readDiagnosticInfoArray("DiagnosticInfos");
            ContentFilterResult filterResult = (ContentFilterResult)decoder.readStruct("FilterResult", ContentFilterResult.TYPE_ID);
            return new QueryFirstResponse(responseHeader, queryDataSets, continuationPoint, parsingResults, diagnosticInfos, filterResult);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, QueryFirstResponse value) {
            encoder.writeStruct("ResponseHeader", (Object)value.getResponseHeader(), ResponseHeader.TYPE_ID);
            encoder.writeStructArray("QueryDataSets", (Object[])value.getQueryDataSets(), QueryDataSet.TYPE_ID);
            encoder.writeByteString("ContinuationPoint", value.getContinuationPoint());
            encoder.writeStructArray("ParsingResults", (Object[])value.getParsingResults(), ParsingResult.TYPE_ID);
            encoder.writeDiagnosticInfoArray("DiagnosticInfos", value.getDiagnosticInfos());
            encoder.writeStruct("FilterResult", (Object)value.getFilterResult(), ContentFilterResult.TYPE_ID);
        }
    }
}

