/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class QueryNextRequest
extends Structure
implements UaRequestMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=619");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=621");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=620");
    private final RequestHeader requestHeader;
    private final Boolean releaseContinuationPoint;
    private final ByteString continuationPoint;

    public QueryNextRequest(RequestHeader requestHeader, Boolean releaseContinuationPoint, ByteString continuationPoint) {
        this.requestHeader = requestHeader;
        this.releaseContinuationPoint = releaseContinuationPoint;
        this.continuationPoint = continuationPoint;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public Boolean getReleaseContinuationPoint() {
        return this.releaseContinuationPoint;
    }

    public ByteString getContinuationPoint() {
        return this.continuationPoint;
    }

    public static final class Codec
    extends GenericDataTypeCodec<QueryNextRequest> {
        @Override
        public Class<QueryNextRequest> getType() {
            return QueryNextRequest.class;
        }

        @Override
        public QueryNextRequest decode(SerializationContext context, UaDecoder decoder) {
            RequestHeader requestHeader = (RequestHeader)decoder.readStruct("RequestHeader", RequestHeader.TYPE_ID);
            Boolean releaseContinuationPoint = decoder.readBoolean("ReleaseContinuationPoint");
            ByteString continuationPoint = decoder.readByteString("ContinuationPoint");
            return new QueryNextRequest(requestHeader, releaseContinuationPoint, continuationPoint);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, QueryNextRequest value) {
            encoder.writeStruct("RequestHeader", (Object)value.getRequestHeader(), RequestHeader.TYPE_ID);
            encoder.writeBoolean("ReleaseContinuationPoint", value.getReleaseContinuationPoint());
            encoder.writeByteString("ContinuationPoint", value.getContinuationPoint());
        }
    }
}

