/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.AggregateConfiguration;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadDetails;

public class ReadProcessedDetails
extends HistoryReadDetails
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=650");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=652");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=651");
    private final DateTime startTime;
    private final DateTime endTime;
    private final Double processingInterval;
    private final NodeId[] aggregateType;
    private final AggregateConfiguration aggregateConfiguration;

    public ReadProcessedDetails(DateTime startTime, DateTime endTime, Double processingInterval, NodeId[] aggregateType, AggregateConfiguration aggregateConfiguration) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.processingInterval = processingInterval;
        this.aggregateType = aggregateType;
        this.aggregateConfiguration = aggregateConfiguration;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public DateTime getStartTime() {
        return this.startTime;
    }

    public DateTime getEndTime() {
        return this.endTime;
    }

    public Double getProcessingInterval() {
        return this.processingInterval;
    }

    public NodeId[] getAggregateType() {
        return this.aggregateType;
    }

    public AggregateConfiguration getAggregateConfiguration() {
        return this.aggregateConfiguration;
    }

    public static final class Codec
    extends GenericDataTypeCodec<ReadProcessedDetails> {
        @Override
        public Class<ReadProcessedDetails> getType() {
            return ReadProcessedDetails.class;
        }

        @Override
        public ReadProcessedDetails decode(SerializationContext context, UaDecoder decoder) {
            DateTime startTime = decoder.readDateTime("StartTime");
            DateTime endTime = decoder.readDateTime("EndTime");
            Double processingInterval = decoder.readDouble("ProcessingInterval");
            NodeId[] aggregateType = decoder.readNodeIdArray("AggregateType");
            AggregateConfiguration aggregateConfiguration = (AggregateConfiguration)decoder.readStruct("AggregateConfiguration", AggregateConfiguration.TYPE_ID);
            return new ReadProcessedDetails(startTime, endTime, processingInterval, aggregateType, aggregateConfiguration);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, ReadProcessedDetails value) {
            encoder.writeDateTime("StartTime", value.getStartTime());
            encoder.writeDateTime("EndTime", value.getEndTime());
            encoder.writeDouble("ProcessingInterval", value.getProcessingInterval());
            encoder.writeNodeIdArray("AggregateType", value.getAggregateType());
            encoder.writeStruct("AggregateConfiguration", (Object)value.getAggregateConfiguration(), AggregateConfiguration.TYPE_ID);
        }
    }
}

