/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class RegisterNodesResponse
extends Structure
implements UaResponseMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=561");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=563");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=562");
    public static final ExpandedNodeId JSON_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=15196");
    private final ResponseHeader responseHeader;
    private final NodeId[] registeredNodeIds;

    public RegisterNodesResponse(ResponseHeader responseHeader, NodeId[] registeredNodeIds) {
        this.responseHeader = responseHeader;
        this.registeredNodeIds = registeredNodeIds;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    public NodeId[] getRegisteredNodeIds() {
        return this.registeredNodeIds;
    }

    public static final class Codec
    extends GenericDataTypeCodec<RegisterNodesResponse> {
        @Override
        public Class<RegisterNodesResponse> getType() {
            return RegisterNodesResponse.class;
        }

        @Override
        public RegisterNodesResponse decode(SerializationContext context, UaDecoder decoder) {
            ResponseHeader responseHeader = (ResponseHeader)decoder.readStruct("ResponseHeader", ResponseHeader.TYPE_ID);
            NodeId[] registeredNodeIds = decoder.readNodeIdArray("RegisteredNodeIds");
            return new RegisterNodesResponse(responseHeader, registeredNodeIds);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, RegisterNodesResponse value) {
            encoder.writeStruct("ResponseHeader", (Object)value.getResponseHeader(), ResponseHeader.TYPE_ID);
            encoder.writeNodeIdArray("RegisteredNodeIds", value.getRegisteredNodeIds());
        }
    }
}

