/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class RepublishRequest
extends Structure
implements UaRequestMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=830");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=832");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=831");
    private final RequestHeader requestHeader;
    private final UInteger subscriptionId;
    private final UInteger retransmitSequenceNumber;

    public RepublishRequest(RequestHeader requestHeader, UInteger subscriptionId, UInteger retransmitSequenceNumber) {
        this.requestHeader = requestHeader;
        this.subscriptionId = subscriptionId;
        this.retransmitSequenceNumber = retransmitSequenceNumber;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public UInteger getSubscriptionId() {
        return this.subscriptionId;
    }

    public UInteger getRetransmitSequenceNumber() {
        return this.retransmitSequenceNumber;
    }

    public static final class Codec
    extends GenericDataTypeCodec<RepublishRequest> {
        @Override
        public Class<RepublishRequest> getType() {
            return RepublishRequest.class;
        }

        @Override
        public RepublishRequest decode(SerializationContext context, UaDecoder decoder) {
            RequestHeader requestHeader = (RequestHeader)decoder.readStruct("RequestHeader", RequestHeader.TYPE_ID);
            UInteger subscriptionId = decoder.readUInt32("SubscriptionId");
            UInteger retransmitSequenceNumber = decoder.readUInt32("RetransmitSequenceNumber");
            return new RepublishRequest(requestHeader, subscriptionId, retransmitSequenceNumber);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, RepublishRequest value) {
            encoder.writeStruct("RequestHeader", (Object)value.getRequestHeader(), RequestHeader.TYPE_ID);
            encoder.writeUInt32("SubscriptionId", value.getSubscriptionId());
            encoder.writeUInt32("RetransmitSequenceNumber", value.getRetransmitSequenceNumber());
        }
    }
}

