/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class TransferSubscriptionsRequest
extends Structure
implements UaRequestMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=839");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=841");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=840");
    private final RequestHeader requestHeader;
    private final UInteger[] subscriptionIds;
    private final Boolean sendInitialValues;

    public TransferSubscriptionsRequest(RequestHeader requestHeader, UInteger[] subscriptionIds, Boolean sendInitialValues) {
        this.requestHeader = requestHeader;
        this.subscriptionIds = subscriptionIds;
        this.sendInitialValues = sendInitialValues;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public UInteger[] getSubscriptionIds() {
        return this.subscriptionIds;
    }

    public Boolean getSendInitialValues() {
        return this.sendInitialValues;
    }

    public static final class Codec
    extends GenericDataTypeCodec<TransferSubscriptionsRequest> {
        @Override
        public Class<TransferSubscriptionsRequest> getType() {
            return TransferSubscriptionsRequest.class;
        }

        @Override
        public TransferSubscriptionsRequest decode(SerializationContext context, UaDecoder decoder) {
            RequestHeader requestHeader = (RequestHeader)decoder.readStruct("RequestHeader", RequestHeader.TYPE_ID);
            UInteger[] subscriptionIds = decoder.readUInt32Array("SubscriptionIds");
            Boolean sendInitialValues = decoder.readBoolean("SendInitialValues");
            return new TransferSubscriptionsRequest(requestHeader, subscriptionIds, sendInitialValues);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, TransferSubscriptionsRequest value) {
            encoder.writeStruct("RequestHeader", (Object)value.getRequestHeader(), RequestHeader.TYPE_ID);
            encoder.writeUInt32Array("SubscriptionIds", value.getSubscriptionIds());
            encoder.writeBoolean("SendInitialValues", value.getSendInitialValues());
        }
    }
}

