/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class UnregisterNodesRequest
extends Structure
implements UaRequestMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=564");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=566");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=565");
    public static final ExpandedNodeId JSON_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=15197");
    private final RequestHeader requestHeader;
    private final NodeId[] nodesToUnregister;

    public UnregisterNodesRequest(RequestHeader requestHeader, NodeId[] nodesToUnregister) {
        this.requestHeader = requestHeader;
        this.nodesToUnregister = nodesToUnregister;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public NodeId[] getNodesToUnregister() {
        return this.nodesToUnregister;
    }

    public static final class Codec
    extends GenericDataTypeCodec<UnregisterNodesRequest> {
        @Override
        public Class<UnregisterNodesRequest> getType() {
            return UnregisterNodesRequest.class;
        }

        @Override
        public UnregisterNodesRequest decode(SerializationContext context, UaDecoder decoder) {
            RequestHeader requestHeader = (RequestHeader)decoder.readStruct("RequestHeader", RequestHeader.TYPE_ID);
            NodeId[] nodesToUnregister = decoder.readNodeIdArray("NodesToUnregister");
            return new UnregisterNodesRequest(requestHeader, nodesToUnregister);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, UnregisterNodesRequest value) {
            encoder.writeStruct("RequestHeader", (Object)value.getRequestHeader(), RequestHeader.TYPE_ID);
            encoder.writeNodeIdArray("NodesToUnregister", value.getNodesToUnregister());
        }
    }
}

