/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;
import org.eclipse.milo.opcua.stack.core.types.structured.WriteValue;

public class WriteRequest
extends Structure
implements UaRequestMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=671");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=673");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=672");
    private final RequestHeader requestHeader;
    private final WriteValue[] nodesToWrite;

    public WriteRequest(RequestHeader requestHeader, WriteValue[] nodesToWrite) {
        this.requestHeader = requestHeader;
        this.nodesToWrite = nodesToWrite;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public WriteValue[] getNodesToWrite() {
        return this.nodesToWrite;
    }

    public static final class Codec
    extends GenericDataTypeCodec<WriteRequest> {
        @Override
        public Class<WriteRequest> getType() {
            return WriteRequest.class;
        }

        @Override
        public WriteRequest decode(SerializationContext context, UaDecoder decoder) {
            RequestHeader requestHeader = (RequestHeader)decoder.readStruct("RequestHeader", RequestHeader.TYPE_ID);
            WriteValue[] nodesToWrite = (WriteValue[])decoder.readStructArray("NodesToWrite", WriteValue.TYPE_ID);
            return new WriteRequest(requestHeader, nodesToWrite);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, WriteRequest value) {
            encoder.writeStruct("RequestHeader", (Object)value.getRequestHeader(), RequestHeader.TYPE_ID);
            encoder.writeStructArray("NodesToWrite", (Object[])value.getNodesToWrite(), WriteValue.TYPE_ID);
        }
    }
}

