/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class XVType
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=12080");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=12082");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=12090");
    private final Double x;
    private final Float value;

    public XVType(Double x, Float value) {
        this.x = x;
        this.value = value;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public Double getX() {
        return this.x;
    }

    public Float getValue() {
        return this.value;
    }

    public static final class Codec
    extends GenericDataTypeCodec<XVType> {
        @Override
        public Class<XVType> getType() {
            return XVType.class;
        }

        @Override
        public XVType decode(SerializationContext context, UaDecoder decoder) {
            Double x = decoder.readDouble("X");
            Float value = decoder.readFloat("Value");
            return new XVType(x, value);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, XVType value) {
            encoder.writeDouble("X", value.getX());
            encoder.writeFloat("Value", value.getValue());
        }
    }
}

