/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.util;

import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.security.SecurityAlgorithm;

public class SignatureUtil {
    private static final ThreadLocal<Map<String, Mac>> MAC_INSTANCES = new ThreadLocal();

    public static byte[] sign(SecurityAlgorithm securityAlgorithm, PrivateKey privateKey, ByteBuffer ... buffers) throws UaException {
        String transformation = securityAlgorithm.getTransformation();
        try {
            Signature signature = Signature.getInstance(transformation);
            signature.initSign(privateKey);
            ByteBuffer[] byteBufferArray = buffers;
            int n = buffers.length;
            int n2 = 0;
            while (n2 < n) {
                ByteBuffer buffer = byteBufferArray[n2];
                signature.update(buffer);
                ++n2;
            }
            return signature.sign();
        }
        catch (GeneralSecurityException e) {
            throw new UaException(0x80020000L, (Throwable)e);
        }
    }

    public static void verify(SecurityAlgorithm algorithm, X509Certificate certificate, byte[] dataBytes, byte[] signatureBytes) throws UaException {
        try {
            Signature signature = Signature.getInstance(algorithm.getTransformation());
            signature.initVerify(certificate);
            signature.update(dataBytes);
            if (!signature.verify(signatureBytes)) {
                throw new UaException(2148728832L, "could not verify signature");
            }
        }
        catch (NoSuchAlgorithmException | SignatureException e) {
            throw new UaException(0x80020000L, (Throwable)e);
        }
        catch (InvalidKeyException e) {
            throw new UaException(2148728832L, (Throwable)e);
        }
    }

    public static byte[] hmac(SecurityAlgorithm securityAlgorithm, byte[] secretKey, ByteBuffer ... buffers) throws UaException {
        String transformation = securityAlgorithm.getTransformation();
        try {
            Mac mac = SignatureUtil.getMacInstance(transformation);
            mac.init(new SecretKeySpec(secretKey, transformation));
            ByteBuffer[] byteBufferArray = buffers;
            int n = buffers.length;
            int n2 = 0;
            while (n2 < n) {
                ByteBuffer buffer = byteBufferArray[n2];
                mac.update(buffer);
                ++n2;
            }
            return mac.doFinal();
        }
        catch (NoSuchAlgorithmException e) {
            throw new UaException(0x80020000L, (Throwable)e);
        }
        catch (GeneralSecurityException e) {
            throw new UaException(2148728832L, (Throwable)e);
        }
    }

    private static Mac getMacInstance(String transformation) throws NoSuchAlgorithmException {
        Mac mac;
        Map<String, Mac> macs = MAC_INSTANCES.get();
        if (macs == null) {
            macs = new HashMap<String, Mac>();
            MAC_INSTANCES.set(macs);
        }
        if ((mac = macs.get(transformation)) == null) {
            mac = Mac.getInstance(transformation);
            macs.put(transformation, mac);
        }
        return mac;
    }
}

