/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.server;

import com.google.common.base.Strings;
import com.google.common.collect.ForwardingTable;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import io.netty.channel.Channel;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.channel.EncodingLimits;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.types.DataTypeManager;
import org.eclipse.milo.opcua.stack.core.types.DefaultDataTypeManager;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.ApplicationType;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MessageSecurityMode;
import org.eclipse.milo.opcua.stack.core.types.structured.ActivateSessionRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.AddNodesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.AddReferencesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.ApplicationDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseNextRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CallRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CancelRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CloseSessionRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateMonitoredItemsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateSessionRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateSubscriptionRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteMonitoredItemsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteNodesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteReferencesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteSubscriptionsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.FindServersOnNetworkRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.FindServersRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.FindServersResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.GetEndpointsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.GetEndpointsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryUpdateRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.ModifyMonitoredItemsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.ModifySubscriptionRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.PublishRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.QueryFirstRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.QueryNextRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.RegisterNodesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.RegisterServer2Request;
import org.eclipse.milo.opcua.stack.core.types.structured.RegisterServerRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.RepublishRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.SetMonitoringModeRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.SetPublishingModeRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.SetTriggeringRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.TransferSubscriptionsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.TranslateBrowsePathsToNodeIdsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.UnregisterNodesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.UserTokenPolicy;
import org.eclipse.milo.opcua.stack.core.types.structured.WriteRequest;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;
import org.eclipse.milo.opcua.stack.core.util.EndpointUtil;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;
import org.eclipse.milo.opcua.stack.core.util.Lazy;
import org.eclipse.milo.opcua.stack.core.util.Unit;
import org.eclipse.milo.opcua.stack.server.EndpointConfiguration;
import org.eclipse.milo.opcua.stack.server.UaStackServerConfig;
import org.eclipse.milo.opcua.stack.server.services.AttributeHistoryServiceSet;
import org.eclipse.milo.opcua.stack.server.services.AttributeServiceSet;
import org.eclipse.milo.opcua.stack.server.services.DiscoveryServiceSet;
import org.eclipse.milo.opcua.stack.server.services.MethodServiceSet;
import org.eclipse.milo.opcua.stack.server.services.MonitoredItemServiceSet;
import org.eclipse.milo.opcua.stack.server.services.NodeManagementServiceSet;
import org.eclipse.milo.opcua.stack.server.services.QueryServiceSet;
import org.eclipse.milo.opcua.stack.server.services.ServiceRequest;
import org.eclipse.milo.opcua.stack.server.services.ServiceRequestHandler;
import org.eclipse.milo.opcua.stack.server.services.SessionServiceSet;
import org.eclipse.milo.opcua.stack.server.services.SubscriptionServiceSet;
import org.eclipse.milo.opcua.stack.server.services.ViewServiceSet;
import org.eclipse.milo.opcua.stack.server.transport.ServerChannelManager;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UaStackServer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ServiceHandlerTable serviceHandlerTable = new ServiceHandlerTable();
    private final LongAdder rejectedRequestCount = new LongAdder();
    private final LongAdder securityRejectedRequestCount = new LongAdder();
    private final Lazy<ApplicationDescription> applicationDescription = new Lazy();
    private final NamespaceTable namespaceTable = new NamespaceTable();
    private final DataTypeManager dataTypeManager = DefaultDataTypeManager.createAndInitialize((NamespaceTable)this.namespaceTable);
    private final AtomicLong channelIds = new AtomicLong();
    private final AtomicLong tokenIds = new AtomicLong();
    private final List<Channel> channels = new CopyOnWriteArrayList<Channel>();
    private final Set<EndpointConfiguration> boundEndpoints = Sets.newConcurrentHashSet();
    private final ServerChannelManager channelManager;
    private final SerializationContext serializationContext;
    private final UaStackServerConfig config;

    public UaStackServer(final UaStackServerConfig config) {
        this.config = config;
        this.channelManager = new ServerChannelManager(this);
        this.serializationContext = new SerializationContext(){

            public EncodingLimits getEncodingLimits() {
                return config.getEncodingLimits();
            }

            public NamespaceTable getNamespaceTable() {
                return UaStackServer.this.namespaceTable;
            }

            public DataTypeManager getDataTypeManager() {
                return UaStackServer.this.dataTypeManager;
            }
        };
        config.getEndpoints().forEach(endpoint -> {
            String path = EndpointUtil.getPath((String)endpoint.getEndpointUrl());
            this.addServiceSet(path, new DefaultDiscoveryServiceSet(this));
        });
    }

    public UaStackServerConfig getConfig() {
        return this.config;
    }

    public CompletableFuture<UaStackServer> startup() {
        ArrayList futures = new ArrayList();
        this.config.getEndpoints().stream().sorted(Comparator.comparing(EndpointConfiguration::getTransportProfile)).forEach(endpoint -> {
            this.logger.info("Binding endpoint {} to {}:{} [{}/{}]", new Object[]{endpoint.getEndpointUrl(), endpoint.getBindAddress(), endpoint.getBindPort(), endpoint.getSecurityPolicy(), endpoint.getSecurityMode()});
            futures.add(((CompletableFuture)this.channelManager.bind((EndpointConfiguration)endpoint).whenComplete((u, ex) -> {
                if (u != null) {
                    this.boundEndpoints.add((EndpointConfiguration)endpoint);
                }
            })).exceptionally(ex -> {
                this.logger.warn("Bind failed for endpoint {}", (Object)endpoint.getEndpointUrl(), ex);
                return Unit.VALUE;
            }));
        });
        return FutureUtils.sequence(futures).thenApply(u -> this);
    }

    public CompletableFuture<UaStackServer> shutdown() {
        ArrayList futures = new ArrayList();
        this.config.getEndpoints().forEach(endpoint -> {
            boolean bl = futures.add(this.channelManager.unbind((EndpointConfiguration)endpoint).exceptionally(ex -> {
                this.logger.warn("Unbind failed for endpoint {}", (Object)endpoint.getEndpointUrl(), ex);
                return Unit.VALUE;
            }));
        });
        this.channels.forEach(channel -> {
            CompletableFuture f = new CompletableFuture();
            channel.close().addListener(fv -> {
                boolean bl = f.complete(Unit.VALUE);
            });
            futures.add(f);
        });
        this.channels.clear();
        this.boundEndpoints.clear();
        return FutureUtils.sequence(futures).thenApply(u -> this);
    }

    public NamespaceTable getNamespaceTable() {
        return this.namespaceTable;
    }

    public DataTypeManager getDataTypeManager() {
        return this.dataTypeManager;
    }

    public SerializationContext getSerializationContext() {
        return this.serializationContext;
    }

    public void registerConnectedChannel(Channel channel) {
        this.channels.add(channel);
    }

    public void unregisterConnectedChannel(Channel channel) {
        this.channels.remove(channel);
    }

    public List<Channel> getConnectedChannels() {
        return this.channels;
    }

    public Set<EndpointConfiguration> getBoundEndpoints() {
        return this.boundEndpoints;
    }

    public void onServiceRequest(String path, ServiceRequest serviceRequest) {
        this.config.getExecutor().execute(() -> this.handleServiceRequest(path, serviceRequest));
    }

    private void handleServiceRequest(String path, ServiceRequest serviceRequest) {
        UaRequestMessage request = serviceRequest.getRequest();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("ServiceRequest received path={}, requestHandle={} request={}", new Object[]{path, request.getRequestHeader().getRequestHandle(), request.getClass().getSimpleName()});
            serviceRequest.getFuture().whenComplete((response, ex) -> {
                if (response != null) {
                    this.logger.trace("ServiceRequest completed path={}, requestHandle={} response={}", new Object[]{path, response.getResponseHeader().getRequestHandle(), response.getClass().getSimpleName()});
                } else {
                    this.logger.trace("ServiceRequest completed exceptionally path={}, requestHandle={}", new Object[]{path, request.getRequestHeader().getRequestHandle(), ex});
                }
            });
        }
        ServiceRequestHandler serviceHandler = this.getServiceHandler(path, request.getTypeId());
        try {
            if (serviceHandler != null) {
                serviceHandler.handle(serviceRequest);
            } else {
                serviceRequest.setServiceFault(0x800B0000L);
            }
        }
        catch (UaException e) {
            serviceRequest.setServiceFault(e);
        }
        catch (Throwable t) {
            this.logger.error("Uncaught Throwable executing handler: {}", (Object)serviceHandler, (Object)t);
            serviceRequest.setServiceFault(0x80020000L);
        }
    }

    public long getNextChannelId() {
        return this.channelIds.incrementAndGet();
    }

    public long getNextTokenId() {
        return this.tokenIds.incrementAndGet();
    }

    private ApplicationDescription getApplicationDescription() {
        return (ApplicationDescription)this.applicationDescription.getOrCompute(() -> {
            List discoveryUrls = this.config.getEndpoints().stream().map(EndpointConfiguration::getEndpointUrl).filter(url -> url.endsWith("/discovery")).distinct().collect(Collectors.toList());
            if (discoveryUrls.isEmpty()) {
                discoveryUrls = this.config.getEndpoints().stream().map(EndpointConfiguration::getEndpointUrl).distinct().collect(Collectors.toList());
            }
            return new ApplicationDescription(this.config.getApplicationUri(), this.config.getProductUri(), this.config.getApplicationName(), ApplicationType.Server, null, null, (String[])ConversionUtil.a(discoveryUrls, String.class));
        });
    }

    public ImmutableList<EndpointDescription> getEndpointDescriptions() {
        return ImmutableList.builder().addAll(this.config.getEndpoints().stream().map(this::transformEndpoint).iterator()).build();
    }

    private EndpointDescription transformEndpoint(EndpointConfiguration endpoint) {
        return new EndpointDescription(endpoint.getEndpointUrl(), this.getApplicationDescription(), this.certificateByteString(endpoint.getCertificate()), endpoint.getSecurityMode(), endpoint.getSecurityPolicy().getUri(), (UserTokenPolicy[])ConversionUtil.a(endpoint.getTokenPolicies(), UserTokenPolicy.class), endpoint.getTransportProfile().getUri(), Unsigned.ubyte((short)UaStackServer.getSecurityLevel(endpoint.getSecurityPolicy(), endpoint.getSecurityMode())));
    }

    private ByteString certificateByteString(@Nullable X509Certificate certificate) {
        if (certificate != null) {
            try {
                return ByteString.of((byte[])certificate.getEncoded());
            }
            catch (CertificateEncodingException e) {
                this.logger.error("Error decoding certificate.", (Throwable)e);
                return ByteString.NULL_VALUE;
            }
        }
        return ByteString.NULL_VALUE;
    }

    private static short getSecurityLevel(SecurityPolicy securityPolicy, MessageSecurityMode securityMode) {
        short securityLevel = 0;
        switch (securityPolicy) {
            case Basic256Sha256: 
            case Aes256_Sha256_RsaPss: {
                securityLevel = (short)(securityLevel | 8);
                break;
            }
            case Aes128_Sha256_RsaOaep: {
                securityLevel = (short)(securityLevel | 4);
                break;
            }
            case Basic128Rsa15: 
            case Basic256: {
                securityLevel = (short)(securityLevel | 1);
                break;
            }
        }
        switch (securityMode) {
            case SignAndEncrypt: {
                securityLevel = (short)(securityLevel | 0x80);
                break;
            }
            case Sign: {
                securityLevel = (short)(securityLevel | 0x40);
                break;
            }
            default: {
                securityLevel = (short)(securityLevel | 0x20);
            }
        }
        return securityLevel;
    }

    public LongAdder getRejectedRequestCount() {
        return this.rejectedRequestCount;
    }

    public LongAdder getSecurityRejectedRequestCount() {
        return this.securityRejectedRequestCount;
    }

    public <T extends UaRequestMessage> void addServiceHandler(String path, ExpandedNodeId dataTypeId, ServiceRequestHandler serviceHandler) {
        this.logger.debug("Adding ServiceHandler for {} at {}", (Object)dataTypeId, (Object)path);
        this.serviceHandlerTable.put(path, dataTypeId, serviceHandler);
    }

    public <T extends UaRequestMessage> void removeServiceHandler(String path, ExpandedNodeId dataTypeId) {
        this.logger.debug("Removing ServiceHandler for {} at {}", (Object)dataTypeId, (Object)path);
        this.serviceHandlerTable.remove(path, dataTypeId);
    }

    @Nullable
    public ServiceRequestHandler getServiceHandler(String path, ExpandedNodeId dataTypeId) {
        return (ServiceRequestHandler)this.serviceHandlerTable.get(path, dataTypeId);
    }

    public void addServiceSet(String path, AttributeServiceSet serviceSet) {
        this.addServiceHandler(path, ReadRequest.TYPE_ID, serviceSet::onRead);
        this.addServiceHandler(path, WriteRequest.TYPE_ID, serviceSet::onWrite);
    }

    public void addServiceSet(String path, AttributeHistoryServiceSet serviceSet) {
        this.addServiceHandler(path, HistoryReadRequest.TYPE_ID, serviceSet::onHistoryRead);
        this.addServiceHandler(path, HistoryUpdateRequest.TYPE_ID, serviceSet::onHistoryUpdate);
    }

    public void addServiceSet(String path, DiscoveryServiceSet serviceSet) {
        this.addServiceHandler(path, GetEndpointsRequest.TYPE_ID, serviceSet::onGetEndpoints);
        this.addServiceHandler(path, FindServersRequest.TYPE_ID, serviceSet::onFindServers);
        this.addServiceHandler(path, FindServersOnNetworkRequest.TYPE_ID, serviceSet::onFindServersOnNetwork);
        this.addServiceHandler(path, RegisterServerRequest.TYPE_ID, serviceSet::onRegisterServer);
        this.addServiceHandler(path, RegisterServer2Request.TYPE_ID, serviceSet::onRegisterServer2);
    }

    public void addServiceSet(String path, QueryServiceSet serviceSet) {
        this.addServiceHandler(path, QueryFirstRequest.TYPE_ID, serviceSet::onQueryFirst);
        this.addServiceHandler(path, QueryNextRequest.TYPE_ID, serviceSet::onQueryNext);
    }

    public void addServiceSet(String path, MethodServiceSet serviceSet) {
        this.addServiceHandler(path, CallRequest.TYPE_ID, serviceSet::onCall);
    }

    public void addServiceSet(String path, MonitoredItemServiceSet serviceSet) {
        this.addServiceHandler(path, CreateMonitoredItemsRequest.TYPE_ID, serviceSet::onCreateMonitoredItems);
        this.addServiceHandler(path, ModifyMonitoredItemsRequest.TYPE_ID, serviceSet::onModifyMonitoredItems);
        this.addServiceHandler(path, DeleteMonitoredItemsRequest.TYPE_ID, serviceSet::onDeleteMonitoredItems);
        this.addServiceHandler(path, SetMonitoringModeRequest.TYPE_ID, serviceSet::onSetMonitoringMode);
        this.addServiceHandler(path, SetTriggeringRequest.TYPE_ID, serviceSet::onSetTriggering);
    }

    public void addServiceSet(String path, NodeManagementServiceSet serviceSet) {
        this.addServiceHandler(path, AddNodesRequest.TYPE_ID, serviceSet::onAddNodes);
        this.addServiceHandler(path, DeleteNodesRequest.TYPE_ID, serviceSet::onDeleteNodes);
        this.addServiceHandler(path, AddReferencesRequest.TYPE_ID, serviceSet::onAddReferences);
        this.addServiceHandler(path, DeleteReferencesRequest.TYPE_ID, serviceSet::onDeleteReferences);
    }

    public void addServiceSet(String path, SessionServiceSet serviceSet) {
        this.addServiceHandler(path, CreateSessionRequest.TYPE_ID, serviceSet::onCreateSession);
        this.addServiceHandler(path, ActivateSessionRequest.TYPE_ID, serviceSet::onActivateSession);
        this.addServiceHandler(path, CloseSessionRequest.TYPE_ID, serviceSet::onCloseSession);
        this.addServiceHandler(path, CancelRequest.TYPE_ID, serviceSet::onCancel);
    }

    public void addServiceSet(String path, SubscriptionServiceSet serviceSet) {
        this.addServiceHandler(path, CreateSubscriptionRequest.TYPE_ID, serviceSet::onCreateSubscription);
        this.addServiceHandler(path, ModifySubscriptionRequest.TYPE_ID, serviceSet::onModifySubscription);
        this.addServiceHandler(path, DeleteSubscriptionsRequest.TYPE_ID, serviceSet::onDeleteSubscriptions);
        this.addServiceHandler(path, TransferSubscriptionsRequest.TYPE_ID, serviceSet::onTransferSubscriptions);
        this.addServiceHandler(path, SetPublishingModeRequest.TYPE_ID, serviceSet::onSetPublishingMode);
        this.addServiceHandler(path, PublishRequest.TYPE_ID, serviceSet::onPublish);
        this.addServiceHandler(path, RepublishRequest.TYPE_ID, serviceSet::onRepublish);
    }

    public void addServiceSet(String path, ViewServiceSet serviceSet) {
        this.addServiceHandler(path, BrowseRequest.TYPE_ID, serviceSet::onBrowse);
        this.addServiceHandler(path, BrowseNextRequest.TYPE_ID, serviceSet::onBrowseNext);
        this.addServiceHandler(path, TranslateBrowsePathsToNodeIdsRequest.TYPE_ID, serviceSet::onTranslateBrowsePaths);
        this.addServiceHandler(path, RegisterNodesRequest.TYPE_ID, serviceSet::onRegisterNodes);
        this.addServiceHandler(path, UnregisterNodesRequest.TYPE_ID, serviceSet::onUnregisterNodes);
    }

    private static class DefaultDiscoveryServiceSet
    implements DiscoveryServiceSet {
        private final Logger logger = LoggerFactory.getLogger(this.getClass());
        private final UaStackServerConfig config;
        private final UaStackServer stackServer;

        public DefaultDiscoveryServiceSet(UaStackServer stackServer) {
            this.stackServer = stackServer;
            this.config = stackServer.getConfig();
        }

        @Override
        public void onGetEndpoints(ServiceRequest serviceRequest) {
            GetEndpointsRequest request = (GetEndpointsRequest)serviceRequest.getRequest();
            ArrayList profileUris = request.getProfileUris() != null ? Lists.newArrayList((Object[])request.getProfileUris()) : new ArrayList();
            List<EndpointDescription> allEndpoints = this.stackServer.getEndpointDescriptions().stream().filter(ed -> !ed.getEndpointUrl().endsWith("/discovery")).filter(ed -> this.filterProfileUris((EndpointDescription)ed, profileUris)).distinct().collect(Collectors.toList());
            ApplicationDescription filteredApplicationDescription = this.getFilteredApplicationDescription(request.getEndpointUrl());
            List<EndpointDescription> matchingEndpoints = allEndpoints.stream().filter(endpoint -> this.filterEndpointUrls((EndpointDescription)endpoint, request.getEndpointUrl())).map(endpoint -> this.replaceApplicationDescription((EndpointDescription)endpoint, filteredApplicationDescription)).distinct().collect(Collectors.toList());
            GetEndpointsResponse response = new GetEndpointsResponse(serviceRequest.createResponseHeader(), matchingEndpoints.isEmpty() ? allEndpoints.toArray(new EndpointDescription[0]) : matchingEndpoints.toArray(new EndpointDescription[0]));
            serviceRequest.setResponse((UaResponseMessage)response);
        }

        private boolean filterProfileUris(EndpointDescription endpoint, List<String> profileUris) {
            return profileUris.size() == 0 || profileUris.contains(endpoint.getTransportProfileUri());
        }

        private boolean filterEndpointUrls(EndpointDescription endpoint, String endpointUrl) {
            try {
                String requestedHost = EndpointUtil.getHost((String)endpointUrl);
                String endpointHost = EndpointUtil.getHost((String)endpoint.getEndpointUrl());
                return Strings.nullToEmpty((String)requestedHost).equalsIgnoreCase(endpointHost);
            }
            catch (Throwable e) {
                this.logger.debug("Unable to create URI.", e);
                return false;
            }
        }

        private EndpointDescription replaceApplicationDescription(EndpointDescription endpoint, ApplicationDescription applicationDescription) {
            return new EndpointDescription(endpoint.getEndpointUrl(), applicationDescription, endpoint.getServerCertificate(), endpoint.getSecurityMode(), endpoint.getSecurityPolicyUri(), endpoint.getUserIdentityTokens(), endpoint.getTransportProfileUri(), endpoint.getSecurityLevel());
        }

        @Override
        public void onFindServers(ServiceRequest serviceRequest) {
            FindServersRequest request = (FindServersRequest)serviceRequest.getRequest();
            ArrayList serverUris = request.getServerUris() != null ? Lists.newArrayList((Object[])request.getServerUris()) : new ArrayList();
            List<Object> applicationDescriptions = Lists.newArrayList((Object[])new ApplicationDescription[]{this.getFilteredApplicationDescription(request.getEndpointUrl())});
            applicationDescriptions = applicationDescriptions.stream().filter(ad -> this.filterServerUris((ApplicationDescription)ad, serverUris)).collect(Collectors.toList());
            FindServersResponse response = new FindServersResponse(serviceRequest.createResponseHeader(), (ApplicationDescription[])ConversionUtil.a((List)applicationDescriptions, ApplicationDescription.class));
            serviceRequest.setResponse((UaResponseMessage)response);
        }

        private ApplicationDescription getFilteredApplicationDescription(String endpointUrl) {
            List<String> allDiscoveryUrls = this.config.getEndpoints().stream().map(EndpointConfiguration::getEndpointUrl).filter(url -> url.endsWith("/discovery")).distinct().collect(Collectors.toList());
            if (allDiscoveryUrls.isEmpty()) {
                allDiscoveryUrls = this.config.getEndpoints().stream().map(EndpointConfiguration::getEndpointUrl).distinct().collect(Collectors.toList());
            }
            List<String> matchingDiscoveryUrls = allDiscoveryUrls.stream().filter(discoveryUrl -> {
                try {
                    String requestedHost = EndpointUtil.getHost((String)endpointUrl);
                    String discoveryHost = EndpointUtil.getHost((String)discoveryUrl);
                    this.logger.debug("requestedHost={}, discoveryHost={}", (Object)requestedHost, (Object)discoveryHost);
                    return Strings.nullToEmpty((String)requestedHost).equalsIgnoreCase(discoveryHost);
                }
                catch (Throwable e) {
                    this.logger.debug("Unable to create URI.", e);
                    return false;
                }
            }).distinct().collect(Collectors.toList());
            this.logger.debug("Matching discovery URLs: {}", matchingDiscoveryUrls);
            return new ApplicationDescription(this.config.getApplicationUri(), this.config.getProductUri(), this.config.getApplicationName(), ApplicationType.Server, null, null, matchingDiscoveryUrls.isEmpty() ? allDiscoveryUrls.toArray(new String[0]) : matchingDiscoveryUrls.toArray(new String[0]));
        }

        private boolean filterServerUris(ApplicationDescription ad, List<String> serverUris) {
            return serverUris.size() == 0 || serverUris.contains(ad.getApplicationUri());
        }
    }

    private static class ServiceHandlerTable
    extends ForwardingTable<String, ExpandedNodeId, ServiceRequestHandler> {
        private final Table<String, ExpandedNodeId, ServiceRequestHandler> delegate = Tables.synchronizedTable((Table)HashBasedTable.create());

        private ServiceHandlerTable() {
        }

        protected Table<String, ExpandedNodeId, ServiceRequestHandler> delegate() {
            return this.delegate;
        }
    }
}

