/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.server.transport.http;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketServerCompressionHandler;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Objects;
import org.eclipse.milo.opcua.stack.core.util.EndpointUtil;
import org.eclipse.milo.opcua.stack.server.UaStackServer;
import org.eclipse.milo.opcua.stack.server.transport.RateLimitingHandler;
import org.eclipse.milo.opcua.stack.server.transport.http.OpcServerHttpRequestHandler;
import org.eclipse.milo.opcua.stack.server.transport.websocket.OpcServerWebSocketFrameHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpcServerHttpChannelInitializer
extends ChannelInitializer<SocketChannel> {
    private SslContext sslContext = null;
    private final UaStackServer stackServer;

    public OpcServerHttpChannelInitializer(UaStackServer stackServer) {
        this.stackServer = stackServer;
        KeyPair keyPair = stackServer.getConfig().getHttpsKeyPair().orElse(null);
        X509Certificate[] httpsCertificate = stackServer.getConfig().getHttpsCertificateChain().orElse(null);
        if (keyPair != null && httpsCertificate != null) {
            try {
                PrivateKey privateKey = keyPair.getPrivate();
                this.sslContext = SslContextBuilder.forServer((PrivateKey)privateKey, (X509Certificate[])httpsCertificate).clientAuth(ClientAuth.NONE).trustManager(InsecureTrustManagerFactory.INSTANCE).build();
            }
            catch (Exception e) {
                LoggerFactory.getLogger(OpcServerHttpChannelInitializer.class).error("Error configuration SslContext: {}", (Object)e.getMessage(), (Object)e);
            }
        } else {
            LoggerFactory.getLogger(OpcServerHttpChannelInitializer.class).warn("HTTPS KeyPair and/or Certificate not configured; falling back to plaintext...");
        }
    }

    protected void initChannel(SocketChannel channel) {
        this.stackServer.registerConnectedChannel((Channel)channel);
        channel.closeFuture().addListener(future -> this.stackServer.unregisterConnectedChannel((Channel)channel));
        channel.pipeline().addLast(new ChannelHandler[]{RateLimitingHandler.getInstance()});
        if (this.sslContext != null) {
            channel.pipeline().addLast(new ChannelHandler[]{this.sslContext.newHandler(channel.alloc())});
        }
        channel.pipeline().addLast(new ChannelHandler[]{new LoggingHandler(LogLevel.TRACE)});
        channel.pipeline().addLast(new ChannelHandler[]{new HttpServerCodec()});
        channel.pipeline().addLast(new ChannelHandler[]{new HttpObjectAggregator(Integer.MAX_VALUE)});
        channel.pipeline().addLast(new ChannelHandler[]{new OpcHttpTransportInterceptor(this.stackServer)});
    }

    private static class OpcHttpTransportInterceptor
    extends SimpleChannelInboundHandler<FullHttpRequest> {
        private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        private final UaStackServer stackServer;

        public OpcHttpTransportInterceptor(UaStackServer stackServer) {
            this.stackServer = stackServer;
        }

        protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest httpRequest) {
            String host = httpRequest.headers().get((CharSequence)HttpHeaderNames.HOST);
            String uri = httpRequest.uri();
            this.logger.debug("host={} uri={}", (Object)host, (Object)uri);
            boolean endpointMatch = this.stackServer.getEndpointDescriptions().stream().anyMatch(endpoint -> Objects.equals(uri, EndpointUtil.getPath((String)endpoint.getEndpointUrl())));
            if (!endpointMatch) {
                this.logger.debug("unrecognized endpoint URL: " + uri);
                DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND);
                ctx.channel().writeAndFlush((Object)response).addListener(future -> {
                    ChannelFuture channelFuture = ctx.close();
                });
                return;
            }
            if (Objects.equals(httpRequest.method(), HttpMethod.GET) && "websocket".equalsIgnoreCase(httpRequest.headers().get((CharSequence)HttpHeaderValues.UPGRADE))) {
                this.logger.debug("intercepted WebSocket upgrade");
                ctx.channel().pipeline().remove((ChannelHandler)this);
                ctx.channel().pipeline().addLast(new ChannelHandler[]{new WebSocketServerCompressionHandler()});
                ctx.channel().pipeline().addLast(new ChannelHandler[]{new WebSocketServerProtocolHandler("/ws", String.format("%s, %s", "opcua+uacp", "opcua+uajson"), true)});
                ctx.channel().pipeline().addLast(new ChannelHandler[]{new OpcServerWebSocketFrameHandler(this.stackServer)});
                httpRequest.retain();
                ctx.executor().execute(() -> {
                    ChannelHandlerContext channelHandlerContext2 = ctx.fireChannelRead((Object)httpRequest);
                });
            } else if (Objects.equals(httpRequest.method(), HttpMethod.POST)) {
                this.logger.debug("intercepted HTTP POST");
                ctx.channel().pipeline().remove((ChannelHandler)this);
                ctx.channel().pipeline().addLast(new ChannelHandler[]{new OpcServerHttpRequestHandler(this.stackServer)});
                httpRequest.retain();
                ctx.executor().execute(() -> {
                    ChannelPipeline channelPipeline = ctx.pipeline().fireChannelRead((Object)httpRequest);
                });
            } else {
                DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST);
                ctx.channel().writeAndFlush((Object)response).addListener(future -> {
                    ChannelFuture channelFuture = ctx.close();
                });
            }
        }
    }
}

