/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.jansi.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import org.fusesource.jansi.internal.OSInfo;

public class JansiLoader {
    private static boolean loaded = false;
    private static String nativeLibraryPath;
    private static String nativeLibrarySourceUrl;

    public static synchronized boolean initialize() {
        block3: {
            if (!loaded) {
                JansiLoader.cleanup();
            }
            try {
                JansiLoader.loadJansiNativeLibrary();
            }
            catch (Exception e) {
                if (Boolean.parseBoolean(System.getProperty("jansi.graceful", "true"))) break block3;
                throw new RuntimeException("Unable to load jansi native library. You may want set the `jansi.graceful` system property to true to be able to use Jansi on your platform", e);
            }
        }
        return loaded;
    }

    public static String getNativeLibraryPath() {
        return nativeLibraryPath;
    }

    public static String getNativeLibrarySourceUrl() {
        return nativeLibrarySourceUrl;
    }

    private static File getTempDir() {
        return new File(System.getProperty("jansi.tmpdir", System.getProperty("java.io.tmpdir")));
    }

    static void cleanup() {
        String tempFolder = JansiLoader.getTempDir().getAbsolutePath();
        File dir = new File(tempFolder);
        File[] nativeLibFiles = dir.listFiles(new FilenameFilter(){
            private final String searchPattern = "jansi-" + JansiLoader.getVersion();

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(this.searchPattern) && !name.endsWith(".lck");
            }
        });
        if (nativeLibFiles != null) {
            File[] fileArray = nativeLibFiles;
            int n = nativeLibFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File nativeLibFile = fileArray[n2];
                File lckFile = new File(String.valueOf(nativeLibFile.getAbsolutePath()) + ".lck");
                if (!lckFile.exists()) {
                    try {
                        nativeLibFile.delete();
                    }
                    catch (SecurityException e) {
                        System.err.println("Failed to delete old native lib" + e.getMessage());
                    }
                }
                ++n2;
            }
        }
    }

    private static int readNBytes(InputStream in, byte[] b) throws IOException {
        int n = 0;
        int len = b.length;
        while (n < len) {
            int count = in.read(b, n, len - n);
            if (count <= 0) break;
            n += count;
        }
        return n;
    }

    private static String contentsEquals(InputStream in1, InputStream in2) throws IOException {
        int numRead2;
        block3: {
            byte[] buffer1 = new byte[8192];
            byte[] buffer2 = new byte[8192];
            do {
                int numRead1 = JansiLoader.readNBytes(in1, buffer1);
                numRead2 = JansiLoader.readNBytes(in2, buffer2);
                if (numRead1 <= 0) break block3;
                if (numRead2 <= 0) {
                    return "EOF on second stream but not first";
                }
                if (numRead2 == numRead1) continue;
                return "Read size different (" + numRead1 + " vs " + numRead2 + ")";
            } while (Arrays.equals(buffer1, buffer2));
            return "Content differs";
        }
        if (numRead2 > 0) {
            return "EOF on first stream but not second";
        }
        return null;
    }

    private static boolean extractAndLoadLibraryFile(String libFolderForCurrentOS, String libraryFileName, String targetFolder) {
        String nativeLibraryFilePath = String.valueOf(libFolderForCurrentOS) + "/" + libraryFileName;
        String uuid = JansiLoader.randomUUID();
        String extractedLibFileName = String.format("jansi-%s-%s-%s", JansiLoader.getVersion(), uuid, libraryFileName);
        String extractedLckFileName = String.valueOf(extractedLibFileName) + ".lck";
        File extractedLibFile = new File(targetFolder, extractedLibFileName);
        File extractedLckFile = new File(targetFolder, extractedLckFileName);
        try {
            Object var13_20;
            Throwable throwable;
            Object var10_13;
            Throwable throwable2;
            try {
                throwable2 = null;
                var10_13 = null;
                try (InputStream in = JansiLoader.class.getResourceAsStream(nativeLibraryFilePath);){
                    if (!extractedLckFile.exists()) {
                        new FileOutputStream(extractedLckFile).close();
                    }
                    throwable = null;
                    var13_20 = null;
                    try (FileOutputStream out = new FileOutputStream(extractedLibFile);){
                        JansiLoader.copy(in, out);
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable2 == null) {
                        throwable2 = throwable4;
                    } else if (throwable2 != throwable4) {
                        throwable2.addSuppressed(throwable4);
                    }
                    throw throwable2;
                }
            }
            finally {
                extractedLibFile.deleteOnExit();
                extractedLckFile.deleteOnExit();
            }
            extractedLibFile.setReadable(true);
            extractedLibFile.setWritable(true);
            extractedLibFile.setExecutable(true);
            throwable2 = null;
            var10_13 = null;
            try (InputStream nativeIn = JansiLoader.class.getResourceAsStream(nativeLibraryFilePath);){
                throwable = null;
                var13_20 = null;
                try (FileInputStream extractedLibIn = new FileInputStream(extractedLibFile);){
                    String eq = JansiLoader.contentsEquals(nativeIn, extractedLibIn);
                    if (eq != null) {
                        throw new RuntimeException(String.format("Failed to write a native library file at %s because %s", extractedLibFile, eq));
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable == null) {
                        throwable = throwable5;
                    } else if (throwable != throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable6) {
                if (throwable2 == null) {
                    throwable2 = throwable6;
                } else if (throwable2 != throwable6) {
                    throwable2.addSuppressed(throwable6);
                }
                throw throwable2;
            }
            if (JansiLoader.loadNativeLibrary(extractedLibFile)) {
                nativeLibrarySourceUrl = JansiLoader.class.getResource(nativeLibraryFilePath).toExternalForm();
                return true;
            }
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
        return false;
    }

    private static String randomUUID() {
        return Long.toHexString(new Random().nextLong());
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        int n;
        byte[] buf = new byte[8192];
        while ((n = in.read(buf)) > 0) {
            out.write(buf, 0, n);
        }
    }

    private static boolean loadNativeLibrary(File libPath) {
        if (libPath.exists()) {
            try {
                String path = libPath.getAbsolutePath();
                System.load(path);
                nativeLibraryPath = path;
                return true;
            }
            catch (UnsatisfiedLinkError e) {
                if (!libPath.canExecute()) {
                    System.err.printf("Failed to load native library:%s. The native library file at %s is not executable, make sure that the directory is mounted on a partition without the noexec flag, or set the jansi.tmpdir system property to point to a proper location.  osinfo: %s%n", libPath.getName(), libPath, OSInfo.getNativeLibFolderPathForCurrentOS());
                } else {
                    System.err.printf("Failed to load native library:%s. osinfo: %s%n", libPath.getName(), OSInfo.getNativeLibFolderPathForCurrentOS());
                }
                System.err.println(e);
                return false;
            }
        }
        return false;
    }

    private static void loadJansiNativeLibrary() throws Exception {
        String packagePath;
        boolean hasNativeLib;
        if (loaded) {
            return;
        }
        LinkedList<String> triedPaths = new LinkedList<String>();
        String jansiNativeLibraryPath = System.getProperty("library.jansi.path");
        String jansiNativeLibraryName = System.getProperty("library.jansi.name");
        if (jansiNativeLibraryName == null) {
            jansiNativeLibraryName = System.mapLibraryName("jansi");
            assert (jansiNativeLibraryName != null);
            if (jansiNativeLibraryName.endsWith(".dylib")) {
                jansiNativeLibraryName = jansiNativeLibraryName.replace(".dylib", ".jnilib");
            }
        }
        if (jansiNativeLibraryPath != null) {
            String withOs = String.valueOf(jansiNativeLibraryPath) + "/" + OSInfo.getNativeLibFolderPathForCurrentOS();
            if (JansiLoader.loadNativeLibrary(new File(withOs, jansiNativeLibraryName))) {
                loaded = true;
                return;
            }
            triedPaths.add(withOs);
            if (JansiLoader.loadNativeLibrary(new File(jansiNativeLibraryPath, jansiNativeLibraryName))) {
                loaded = true;
                return;
            }
            triedPaths.add(jansiNativeLibraryPath);
        }
        if (hasNativeLib = JansiLoader.hasResource(String.valueOf(jansiNativeLibraryPath = String.format("/%s/native/%s", packagePath = JansiLoader.class.getPackage().getName().replace('.', '/'), OSInfo.getNativeLibFolderPathForCurrentOS())) + "/" + jansiNativeLibraryName)) {
            String tempFolder = JansiLoader.getTempDir().getAbsolutePath();
            if (JansiLoader.extractAndLoadLibraryFile(jansiNativeLibraryPath, jansiNativeLibraryName, tempFolder)) {
                loaded = true;
                return;
            }
            triedPaths.add(jansiNativeLibraryPath);
        }
        String javaLibraryPath = System.getProperty("java.library.path", "");
        String[] stringArray = javaLibraryPath.split(File.pathSeparator);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String ldPath = stringArray[n2];
            if (!ldPath.isEmpty()) {
                if (JansiLoader.loadNativeLibrary(new File(ldPath, jansiNativeLibraryName))) {
                    loaded = true;
                    return;
                }
                triedPaths.add(ldPath);
            }
            ++n2;
        }
        throw new Exception(String.format("No native library found for os.name=%s, os.arch=%s, paths=[%s]", OSInfo.getOSName(), OSInfo.getArchName(), JansiLoader.join(triedPaths, File.pathSeparator)));
    }

    private static boolean hasResource(String path) {
        return JansiLoader.class.getResource(path) != null;
    }

    public static int getMajorVersion() {
        String[] c = JansiLoader.getVersion().split("\\.");
        return c.length > 0 ? Integer.parseInt(c[0]) : 1;
    }

    public static int getMinorVersion() {
        String[] c = JansiLoader.getVersion().split("\\.");
        return c.length > 1 ? Integer.parseInt(c[1]) : 0;
    }

    public static String getVersion() {
        URL versionFile = JansiLoader.class.getResource("/org/fusesource/jansi/jansi.properties");
        String version = "unknown";
        try {
            if (versionFile != null) {
                Properties versionData = new Properties();
                versionData.load(versionFile.openStream());
                version = versionData.getProperty("version", version);
                version = version.trim().replaceAll("[^0-9.]", "");
            }
        }
        catch (IOException e) {
            System.err.println(e);
        }
        return version;
    }

    private static String join(List<String> list, String separator) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String item : list) {
            if (first) {
                first = false;
            } else {
                sb.append(separator);
            }
            sb.append(item);
        }
        return sb.toString();
    }
}

