/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glassfish.grizzly.attributes.AttributeBuilder;

public class Grizzly {
    private static final Pattern versionPattern;
    public static final AttributeBuilder DEFAULT_ATTRIBUTE_BUILDER;
    private static final String dotedVersion;
    private static final int major;
    private static final int minor;
    private static boolean isTrackingThreadCache;

    static {
        String version;
        Matcher matcher;
        Properties prop;
        block16: {
            versionPattern = Pattern.compile("((\\d+)\\.(\\d+)(\\.\\d+)*){1}(?:-(.+))?");
            DEFAULT_ATTRIBUTE_BUILDER = AttributeBuilder.DEFAULT_ATTRIBUTE_BUILDER;
            InputStream is = null;
            prop = new Properties();
            try {
                try {
                    is = Grizzly.class.getResourceAsStream("version.properties");
                    prop.load(is);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        if ((matcher = versionPattern.matcher(version = prop.getProperty("grizzly.version"))).matches()) {
            dotedVersion = matcher.group(1);
            major = Integer.parseInt(matcher.group(2));
            minor = Integer.parseInt(matcher.group(3));
        } else {
            dotedVersion = "no.version";
            major = -1;
            minor = -1;
        }
    }

    public static Logger logger(Class clazz) {
        return Logger.getLogger(clazz.getName());
    }

    public static void main(String[] args) {
        System.out.println(Grizzly.getDotedVersion());
    }

    public static String getDotedVersion() {
        return dotedVersion;
    }

    public static int getMajorVersion() {
        return major;
    }

    public static int getMinorVersion() {
        return minor;
    }

    public static boolean equalVersion(int major, int minor) {
        return minor == Grizzly.minor && major == Grizzly.major;
    }

    public static boolean isTrackingThreadCache() {
        return isTrackingThreadCache;
    }

    public static void setTrackingThreadCache(boolean isTrackingThreadCache) {
        Grizzly.isTrackingThreadCache = isTrackingThreadCache;
    }
}

