/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Context;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.IOEventLifeCycleListener;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.ProcessorResult;
import org.glassfish.grizzly.localization.LogMessages;

public final class ProcessorExecutor {
    private static final Logger LOGGER = Grizzly.logger(ProcessorExecutor.class);

    public static void execute(Connection connection, IOEvent ioEvent, Processor processor, IOEventLifeCycleListener lifeCycleListener) {
        ProcessorExecutor.execute(Context.create(connection, processor, ioEvent, lifeCycleListener));
    }

    public static void execute(Context context) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "executing connection ({0}). IOEvent={1} processor={2}", new Object[]{context.getConnection(), context.getIoEvent(), context.getProcessor()});
        }
        try {
            ProcessorResult result;
            boolean isRerun;
            do {
                boolean bl = isRerun = (result = context.getProcessor().process(context)).getStatus() == ProcessorResult.Status.RERUN;
                if (!isRerun) continue;
                Context newContext = (Context)result.getData();
                ProcessorExecutor.rerun(context, newContext);
                context = newContext;
            } while (isRerun);
            ProcessorExecutor.complete0(context, result);
        }
        catch (Throwable t) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_PROCESSOR_ERROR(context.getConnection(), (Object)context.getIoEvent(), context.getProcessor()), t);
            }
            try {
                ProcessorExecutor.error(context, t);
            }
            catch (Exception exception) {}
        }
    }

    public static void resume(Context context) throws IOException {
        ProcessorExecutor.execute(context);
    }

    private static void complete(Context context, Object data) throws IOException {
        int sz = context.lifeCycleListeners.size();
        IOEventLifeCycleListener[] listeners = context.lifeCycleListeners.array();
        try {
            int i = 0;
            while (i < sz) {
                listeners[i].onComplete(context, data);
                ++i;
            }
        }
        finally {
            context.recycle();
        }
    }

    private static void leave(Context context) throws IOException {
        int sz = context.lifeCycleListeners.size();
        IOEventLifeCycleListener[] listeners = context.lifeCycleListeners.array();
        try {
            int i = 0;
            while (i < sz) {
                listeners[i].onLeave(context);
                ++i;
            }
        }
        finally {
            context.recycle();
        }
    }

    private static void reregister(Context context, Object data) throws IOException {
        Context realContext = (Context)data;
        int sz = context.lifeCycleListeners.size();
        IOEventLifeCycleListener[] listeners = context.lifeCycleListeners.array();
        try {
            int i = 0;
            while (i < sz) {
                listeners[i].onReregister(realContext);
                ++i;
            }
        }
        finally {
            realContext.recycle();
        }
    }

    private static void rerun(Context context, Context newContext) throws IOException {
        int sz = context.lifeCycleListeners.size();
        IOEventLifeCycleListener[] listeners = context.lifeCycleListeners.array();
        int i = 0;
        while (i < sz) {
            listeners[i].onRerun(context, newContext);
            ++i;
        }
    }

    private static void error(Context context, Object description) throws IOException {
        int sz = context.lifeCycleListeners.size();
        IOEventLifeCycleListener[] listeners = context.lifeCycleListeners.array();
        try {
            int i = 0;
            while (i < sz) {
                listeners[i].onError(context, description);
                ++i;
            }
        }
        finally {
            context.release();
        }
    }

    private static void notRun(Context context) throws IOException {
        int sz = context.lifeCycleListeners.size();
        IOEventLifeCycleListener[] listeners = context.lifeCycleListeners.array();
        try {
            int i = 0;
            while (i < sz) {
                listeners[i].onNotRun(context);
                ++i;
            }
        }
        finally {
            context.recycle();
        }
    }

    static void complete(Context context, ProcessorResult result) {
        try {
            ProcessorExecutor.complete0(context, result);
        }
        catch (Throwable t) {
            try {
                ProcessorExecutor.error(context, t);
            }
            catch (Exception exception) {}
        }
    }

    private static void complete0(Context context, ProcessorResult result) throws IllegalStateException, IOException {
        ProcessorResult.Status status = result.getStatus();
        switch (status) {
            case COMPLETE: {
                ProcessorExecutor.complete(context, result.getData());
                break;
            }
            case LEAVE: {
                ProcessorExecutor.leave(context);
                break;
            }
            case TERMINATE: {
                break;
            }
            case REREGISTER: {
                ProcessorExecutor.reregister(context, result.getData());
                break;
            }
            case ERROR: {
                ProcessorExecutor.error(context, result.getData());
                break;
            }
            case NOT_RUN: {
                ProcessorExecutor.notRun(context);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }
}

