/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.filterchain;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.glassfish.grizzly.filterchain.AbstractFilterChain;
import org.glassfish.grizzly.filterchain.Filter;

public abstract class ListFacadeFilterChain
extends AbstractFilterChain {
    protected final List<Filter> filters;

    public ListFacadeFilterChain(List<Filter> filtersImpl) {
        this.filters = filtersImpl;
    }

    @Override
    public boolean add(Filter filter) {
        if (this.filters.add(filter)) {
            filter.onAdded(this);
            this.notifyChangedExcept(filter);
            return true;
        }
        return false;
    }

    @Override
    public void add(int index, Filter filter) {
        this.filters.add(index, filter);
        filter.onAdded(this);
        this.notifyChangedExcept(filter);
    }

    @Override
    public boolean addAll(Collection<? extends Filter> c) {
        for (Filter filter : c) {
            this.filters.add(filter);
            filter.onAdded(this);
        }
        this.notifyChangedExcept(null);
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends Filter> c) {
        int i = 0;
        for (Filter filter : c) {
            this.filters.add(index + i++, filter);
            filter.onAdded(this);
        }
        this.notifyChangedExcept(null);
        return true;
    }

    @Override
    public Filter set(int index, Filter filter) {
        Filter oldFilter = this.filters.set(index, filter);
        if (oldFilter != filter) {
            if (oldFilter != null) {
                oldFilter.onRemoved(this);
            }
            filter.onAdded(this);
            this.notifyChangedExcept(filter);
        }
        return oldFilter;
    }

    @Override
    public final Filter get(int index) {
        return this.filters.get(index);
    }

    @Override
    public int indexOf(Object object) {
        return this.filters.indexOf(object);
    }

    @Override
    public int lastIndexOf(Object filter) {
        return this.filters.lastIndexOf(filter);
    }

    @Override
    public boolean contains(Object filter) {
        return this.filters.contains(filter);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.filters.containsAll(c);
    }

    @Override
    public Object[] toArray() {
        return this.filters.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.filters.toArray(a);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object object) {
        Filter filter = (Filter)object;
        if (this.filters.remove(filter)) {
            filter.onRemoved(this);
            this.notifyChangedExcept(filter);
            return true;
        }
        return false;
    }

    @Override
    public Filter remove(int index) {
        Filter filter = this.filters.remove(index);
        if (filter != null) {
            filter.onRemoved(this);
            this.notifyChangedExcept(filter);
            return filter;
        }
        return null;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.filters == null || this.filters.isEmpty();
    }

    @Override
    public int size() {
        return this.filters.size();
    }

    @Override
    public void clear() {
        Object[] localFilters = this.filters.toArray();
        this.filters.clear();
        Object[] objectArray = localFilters;
        int n = localFilters.length;
        int n2 = 0;
        while (n2 < n) {
            Object filter = objectArray[n2];
            ((Filter)filter).onRemoved(this);
            ++n2;
        }
    }

    @Override
    public Iterator<Filter> iterator() {
        return this.filters.iterator();
    }

    @Override
    public ListIterator<Filter> listIterator() {
        return this.filters.listIterator();
    }

    @Override
    public ListIterator<Filter> listIterator(int index) {
        return this.filters.listIterator(index);
    }

    protected void notifyChangedExcept(Filter filter) {
        for (Filter currentFilter : this.filters) {
            if (currentFilter == filter) continue;
            currentFilter.onFilterChainChanged(this);
        }
    }
}

