/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.jmxbase;

import java.util.Iterator;
import org.glassfish.grizzly.monitoring.MonitoringUtils;
import org.glassfish.grizzly.utils.ServiceFinder;

public abstract class GrizzlyJmxManager {
    private static final GrizzlyJmxManager manager;

    static {
        GrizzlyJmxManager jmxManager;
        ServiceFinder<GrizzlyJmxManager> serviceFinder = ServiceFinder.find(GrizzlyJmxManager.class);
        Iterator<GrizzlyJmxManager> it = serviceFinder.iterator();
        if (it.hasNext()) {
            jmxManager = it.next();
        } else {
            try {
                jmxManager = (GrizzlyJmxManager)GrizzlyJmxManager.loadClass("org.glassfish.grizzly.monitoring.jmx.DefaultJmxManager").newInstance();
            }
            catch (Exception exception) {
                jmxManager = new NullJmxManager();
            }
        }
        manager = jmxManager;
    }

    private static Class<?> loadClass(String classname) throws ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = MonitoringUtils.class.getClassLoader();
        }
        return classLoader.loadClass(classname);
    }

    public static GrizzlyJmxManager instance() {
        return manager;
    }

    public abstract Object registerAtRoot(Object var1);

    public abstract Object registerAtRoot(Object var1, String var2);

    public abstract Object register(Object var1, Object var2);

    public abstract Object register(Object var1, Object var2, String var3);

    public abstract void deregister(Object var1);

    private static final class NullJmxManager
    extends GrizzlyJmxManager {
        private NullJmxManager() {
        }

        @Override
        public Object registerAtRoot(Object object) {
            return null;
        }

        @Override
        public Object registerAtRoot(Object object, String name) {
            return null;
        }

        @Override
        public Object register(Object parent, Object object) {
            return null;
        }

        @Override
        public Object register(Object parent, Object object, String name) {
            return null;
        }

        @Override
        public void deregister(Object object) {
        }
    }
}

