/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.nio.NIOConnection;
import org.glassfish.grizzly.nio.SelectionKeyHandler;

public final class DefaultSelectionKeyHandler
implements SelectionKeyHandler {
    private static final Logger LOGGER = Grizzly.logger(DefaultSelectionKeyHandler.class);
    private static final IOEvent[][] ioEventMap = new IOEvent[32][];

    static {
        int i = 0;
        while (i < ioEventMap.length) {
            int idx = 0;
            IOEvent[] tmpArray = new IOEvent[4];
            if ((i & 1) != 0) {
                tmpArray[idx++] = IOEvent.READ;
            }
            if ((i & 4) != 0) {
                tmpArray[idx++] = IOEvent.WRITE;
            }
            if ((i & 8) != 0) {
                tmpArray[idx++] = IOEvent.CLIENT_CONNECTED;
            }
            if ((i & 0x10) != 0) {
                tmpArray[idx++] = IOEvent.SERVER_ACCEPT;
            }
            DefaultSelectionKeyHandler.ioEventMap[i] = Arrays.copyOf(tmpArray, idx);
            ++i;
        }
    }

    @Override
    public void onKeyRegistered(SelectionKey key) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "KEY IS REGISTERED: {0}", key);
        }
    }

    @Override
    public void onKeyDeregistered(SelectionKey key) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "KEY IS DEREGISTERED: {0}", key);
        }
    }

    @Override
    public void cancel(SelectionKey key) throws IOException {
        this.onKeyDeregistered(key);
        key.cancel();
    }

    @Override
    public int ioEvent2SelectionKeyInterest(IOEvent ioEvent) {
        switch (ioEvent) {
            case READ: {
                return 1;
            }
            case WRITE: {
                return 4;
            }
            case SERVER_ACCEPT: {
                return 16;
            }
            case CLIENT_CONNECTED: {
                return 8;
            }
        }
        return 0;
    }

    @Override
    public IOEvent[] getIOEvents(int interest) {
        return ioEventMap[interest];
    }

    @Override
    public IOEvent selectionKeyInterest2IoEvent(int selectionKeyInterest) {
        if ((selectionKeyInterest & 1) != 0) {
            return IOEvent.READ;
        }
        if ((selectionKeyInterest & 4) != 0) {
            return IOEvent.WRITE;
        }
        if ((selectionKeyInterest & 0x10) != 0) {
            return IOEvent.SERVER_ACCEPT;
        }
        if ((selectionKeyInterest & 8) != 0) {
            return IOEvent.CLIENT_CONNECTED;
        }
        return IOEvent.NONE;
    }

    @Override
    public boolean onProcessInterest(SelectionKey key, int interest) throws IOException {
        return true;
    }

    @Override
    public NIOConnection getConnectionForKey(SelectionKey selectionKey) {
        return (NIOConnection)selectionKey.attachment();
    }

    @Override
    public void setConnectionForKey(NIOConnection connection, SelectionKey selectionKey) {
        selectionKey.attach(connection);
    }
}

