/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.GracefulShutdownListener;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.ShutdownContext;
import org.glassfish.grizzly.Transport;
import org.glassfish.grizzly.localization.LogMessages;
import org.glassfish.grizzly.nio.NIOTransport;

class GracefulShutdownRunner
implements Runnable {
    private static final Logger LOGGER = Grizzly.logger(GracefulShutdownRunner.class);
    private final NIOTransport transport;
    private final Set<GracefulShutdownListener> shutdownListeners;
    private final ExecutorService shutdownService;
    private final long gracePeriod;
    private final TimeUnit timeUnit;

    GracefulShutdownRunner(NIOTransport transport, Set<GracefulShutdownListener> shutdownListeners, ExecutorService shutdownService, long gracePeriod, TimeUnit timeUnit) {
        this.transport = transport;
        this.shutdownListeners = shutdownListeners;
        this.shutdownService = shutdownService;
        this.gracePeriod = gracePeriod;
        this.timeUnit = timeUnit;
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        listenerCount = this.shutdownListeners.size();
        shutdownLatch = new CountDownLatch(listenerCount);
        contexts = new HashMap<ShutdownContext, GracefulShutdownListener>(listenerCount);
        if (this.gracePeriod <= 0L) {
            for (GracefulShutdownListener l : this.shutdownListeners) {
                ctx = this.createContext(contexts, l, shutdownLatch);
                l.shutdownRequested(ctx);
            }
        } else {
            this.shutdownService.execute(new Runnable(){

                @Override
                public void run() {
                    for (GracefulShutdownListener l : GracefulShutdownRunner.this.shutdownListeners) {
                        ShutdownContext ctx = GracefulShutdownRunner.this.createContext(contexts, l, shutdownLatch);
                        l.shutdownRequested(ctx);
                    }
                }
            });
        }
        try {
            try {
                if (this.gracePeriod <= 0L) {
                    shutdownLatch.await();
                    return;
                } else {
                    if (GracefulShutdownRunner.LOGGER.isLoggable(Level.WARNING)) {
                        GracefulShutdownRunner.LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_GRACEFULSHUTDOWN_MSG(String.valueOf(this.transport.getName()) + '[' + Integer.toHexString(this.hashCode()) + ']', this.gracePeriod, (Object)this.timeUnit));
                    }
                    if (result = shutdownLatch.await(this.gracePeriod, this.timeUnit)) return;
                    if (GracefulShutdownRunner.LOGGER.isLoggable(Level.WARNING)) {
                        GracefulShutdownRunner.LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_GRACEFULSHUTDOWN_EXCEEDED(String.valueOf(this.transport.getName()) + '[' + Integer.toHexString(this.hashCode()) + ']'));
                    }
                    if (contexts.isEmpty()) return;
                    for (GracefulShutdownListener l : contexts.values()) {
                        l.shutdownForced();
                    }
                }
                return;
            }
            catch (InterruptedException v0) {
                if (GracefulShutdownRunner.LOGGER.isLoggable(Level.WARNING)) {
                    GracefulShutdownRunner.LOGGER.warning(LogMessages.WARNING_GRIZZLY_GRACEFULSHUTDOWN_INTERRUPTED());
                }
                if (contexts.isEmpty()) return;
                ** for (l : contexts.values())
            }
lbl-1000:
            // 1 sources

            {
                l.shutdownForced();
                continue;
lbl33:
                // 1 sources

                return;
            }
        }
        finally {
            lock = this.transport.getState().getStateLocker().writeLock();
            lock.lock();
            try {
                if (this.transport.shutdownService == this.shutdownService) {
                    this.transport.finalizeShutdown();
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    private ShutdownContext createContext(final Map<ShutdownContext, GracefulShutdownListener> contexts, GracefulShutdownListener listener, final CountDownLatch shutdownLatch) {
        ShutdownContext ctx = new ShutdownContext(){
            boolean isNotified;

            @Override
            public Transport getTransport() {
                return GracefulShutdownRunner.this.transport;
            }

            @Override
            public synchronized void ready() {
                if (!this.isNotified) {
                    this.isNotified = true;
                    contexts.remove(this);
                    shutdownLatch.countDown();
                }
            }
        };
        contexts.put(ctx, listener);
        return ctx;
    }
}

