/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.ssl;

import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.glassfish.grizzly.AbstractTransformer;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.TransformationException;
import org.glassfish.grizzly.TransformationResult;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.ByteBufferArray;
import org.glassfish.grizzly.memory.CompositeBuffer;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.ssl.SSLUtils;

public final class SSLEncoderTransformer
extends AbstractTransformer<Buffer, Buffer> {
    public static final int NEED_HANDSHAKE_ERROR = 1;
    public static final int BUFFER_UNDERFLOW_ERROR = 2;
    public static final int BUFFER_OVERFLOW_ERROR = 3;
    private static final Logger LOGGER = Grizzly.logger(SSLEncoderTransformer.class);
    private static final TransformationResult<Buffer, Buffer> HANDSHAKE_NOT_EXECUTED_RESULT = TransformationResult.createErrorResult(1, "Handshake was not executed");
    private final MemoryManager memoryManager;

    public SSLEncoderTransformer() {
        this(MemoryManager.DEFAULT_MEMORY_MANAGER);
    }

    public SSLEncoderTransformer(MemoryManager memoryManager) {
        this.memoryManager = memoryManager;
    }

    @Override
    public String getName() {
        return SSLEncoderTransformer.class.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected TransformationResult<Buffer, Buffer> transformImpl(AttributeStorage state, Buffer originalMessage) throws TransformationException {
        SSLEngine sslEngine = SSLUtils.getSSLEngine((Connection)state);
        if (sslEngine == null) {
            return HANDSHAKE_NOT_EXECUTED_RESULT;
        }
        AttributeStorage attributeStorage = state;
        synchronized (attributeStorage) {
            return this.wrapAll(sslEngine, originalMessage);
        }
    }

    private TransformationResult<Buffer, Buffer> wrapAll(SSLEngine sslEngine, Buffer originalMessage) throws TransformationException {
        TransformationResult<Buffer, Buffer> transformationResult = null;
        Buffer targetBuffer = null;
        Buffer currentTargetBuffer = null;
        ByteBufferArray originalByteBufferArray = originalMessage.toByteBufferArray();
        boolean restore = false;
        int i = 0;
        while (i < originalByteBufferArray.size()) {
            ByteBuffer originalByteBuffer;
            block13: {
                int pos = originalMessage.position();
                originalByteBuffer = ((ByteBuffer[])originalByteBufferArray.getArray())[i];
                currentTargetBuffer = SSLEncoderTransformer.allowDispose(this.memoryManager.allocate(sslEngine.getSession().getPacketBufferSize()));
                ByteBuffer currentTargetByteBuffer = currentTargetBuffer.toByteBuffer();
                try {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "SSLEncoder engine: {0} input: {1} output: {2}", new Object[]{sslEngine, originalByteBuffer, currentTargetByteBuffer});
                    }
                    SSLEngineResult sslEngineResult = SSLUtils.sslEngineWrap(sslEngine, originalByteBuffer, currentTargetByteBuffer);
                    if (pos == originalMessage.position()) {
                        restore = true;
                        originalMessage.position(pos + sslEngineResult.bytesConsumed());
                    }
                    SSLEngineResult.Status status = sslEngineResult.getStatus();
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "SSLEncoder done engine: {0} result: {1} input: {2} output: {3}", new Object[]{sslEngine, sslEngineResult, originalByteBuffer, currentTargetByteBuffer});
                    }
                    if (status == SSLEngineResult.Status.OK) {
                        currentTargetBuffer.position(sslEngineResult.bytesProduced());
                        currentTargetBuffer.trim();
                        targetBuffer = Buffers.appendBuffers(this.memoryManager, targetBuffer, currentTargetBuffer);
                        break block13;
                    }
                    if (status == SSLEngineResult.Status.CLOSED) {
                        transformationResult = TransformationResult.createCompletedResult(Buffers.EMPTY_BUFFER, originalMessage);
                        break;
                    }
                    if (status == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                        transformationResult = TransformationResult.createErrorResult(2, "Buffer underflow during wrap operation");
                        break;
                    }
                    if (status != SSLEngineResult.Status.BUFFER_OVERFLOW) break;
                    transformationResult = TransformationResult.createErrorResult(3, "Buffer overflow during wrap operation");
                    break;
                }
                catch (SSLException e) {
                    SSLEncoderTransformer.disposeBuffers(currentTargetBuffer, targetBuffer);
                    originalByteBufferArray.restore();
                    throw new TransformationException(e);
                }
            }
            if (originalByteBuffer.hasRemaining()) {
                --i;
            }
            ++i;
        }
        assert (!originalMessage.hasRemaining());
        if (restore) {
            originalByteBufferArray.restore();
        }
        originalByteBufferArray.recycle();
        if (transformationResult != null) {
            SSLEncoderTransformer.disposeBuffers(currentTargetBuffer, targetBuffer);
            return transformationResult;
        }
        return TransformationResult.createCompletedResult(SSLEncoderTransformer.allowDispose(targetBuffer), originalMessage);
    }

    private static void disposeBuffers(Buffer currentBuffer, Buffer bigBuffer) {
        if (currentBuffer != null) {
            currentBuffer.dispose();
        }
        if (bigBuffer != null) {
            bigBuffer.allowBufferDispose(true);
            if (bigBuffer.isComposite()) {
                ((CompositeBuffer)bigBuffer).allowInternalBuffersDispose(true);
            }
            bigBuffer.dispose();
        }
    }

    private static Buffer allowDispose(Buffer buffer) {
        buffer.allowBufferDispose(true);
        if (buffer.isComposite()) {
            ((CompositeBuffer)buffer).allowInternalBuffersDispose(true);
        }
        return buffer;
    }

    @Override
    public boolean hasInputRemaining(AttributeStorage storage, Buffer input) {
        return input != null && input.hasRemaining();
    }
}

