/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.ssl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.ssl.SSLContextConfigurator;
import org.glassfish.grizzly.ssl.SSLEngineFactory;

public class SSLEngineConfigurator
implements SSLEngineFactory {
    private static final Logger LOGGER = Grizzly.logger(SSLEngineConfigurator.class);
    private final Object sync = new Object();
    protected volatile SSLContextConfigurator sslContextConfiguration;
    protected volatile SSLContext sslContext;
    protected String[] enabledCipherSuites = null;
    protected String[] enabledProtocols = null;
    protected boolean clientMode;
    protected boolean needClientAuth;
    protected boolean wantClientAuth;
    private boolean isProtocolConfigured = false;
    private boolean isCipherConfigured = false;

    public SSLEngineConfigurator(SSLContext sslContext) {
        this(sslContext, true, false, false);
    }

    public SSLEngineConfigurator(SSLContext sslContext, boolean clientMode, boolean needClientAuth, boolean wantClientAuth) {
        if (sslContext == null) {
            throw new IllegalArgumentException("SSLContext can not be null");
        }
        this.sslContextConfiguration = null;
        this.sslContext = sslContext;
        this.clientMode = clientMode;
        this.needClientAuth = needClientAuth;
        this.wantClientAuth = wantClientAuth;
    }

    public SSLEngineConfigurator(SSLContextConfigurator sslContextConfiguration) {
        this(sslContextConfiguration, true, false, false);
    }

    public SSLEngineConfigurator(SSLContextConfigurator sslContextConfiguration, boolean clientMode, boolean needClientAuth, boolean wantClientAuth) {
        if (sslContextConfiguration == null) {
            throw new IllegalArgumentException("SSLContextConfigurator can not be null");
        }
        this.sslContextConfiguration = sslContextConfiguration;
        this.clientMode = clientMode;
        this.needClientAuth = needClientAuth;
        this.wantClientAuth = wantClientAuth;
    }

    public SSLEngineConfigurator(SSLEngineConfigurator pattern) {
        this.sslContextConfiguration = pattern.sslContextConfiguration;
        this.sslContext = pattern.sslContext;
        this.clientMode = pattern.clientMode;
        this.needClientAuth = pattern.needClientAuth;
        this.wantClientAuth = pattern.wantClientAuth;
        this.enabledCipherSuites = pattern.enabledCipherSuites != null ? Arrays.copyOf(pattern.enabledCipherSuites, pattern.enabledCipherSuites.length) : null;
        this.enabledProtocols = pattern.enabledProtocols != null ? Arrays.copyOf(pattern.enabledProtocols, pattern.enabledProtocols.length) : null;
        this.isCipherConfigured = pattern.isCipherConfigured;
        this.isProtocolConfigured = pattern.isProtocolConfigured;
    }

    protected SSLEngineConfigurator() {
    }

    public SSLEngine createSSLEngine() {
        return this.createSSLEngine(null, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SSLEngine createSSLEngine(String peerHost, int peerPort) {
        if (this.sslContext == null) {
            Object object = this.sync;
            synchronized (object) {
                if (this.sslContext == null) {
                    this.sslContext = this.sslContextConfiguration.createSSLContext(true);
                }
            }
        }
        SSLEngine sslEngine = this.sslContext.createSSLEngine(peerHost, peerPort);
        this.configure(sslEngine);
        return sslEngine;
    }

    public SSLEngine configure(SSLEngine sslEngine) {
        if (this.enabledCipherSuites != null) {
            if (!this.isCipherConfigured) {
                this.enabledCipherSuites = SSLEngineConfigurator.configureEnabledCiphers(sslEngine, this.enabledCipherSuites);
                this.isCipherConfigured = true;
            }
            sslEngine.setEnabledCipherSuites(this.enabledCipherSuites);
        }
        if (this.enabledProtocols != null) {
            if (!this.isProtocolConfigured) {
                this.enabledProtocols = SSLEngineConfigurator.configureEnabledProtocols(sslEngine, this.enabledProtocols);
                this.isProtocolConfigured = true;
            }
            sslEngine.setEnabledProtocols(this.enabledProtocols);
        }
        sslEngine.setUseClientMode(this.clientMode);
        if (this.wantClientAuth) {
            sslEngine.setWantClientAuth(this.wantClientAuth);
        }
        if (this.needClientAuth) {
            sslEngine.setNeedClientAuth(this.needClientAuth);
        }
        return sslEngine;
    }

    public boolean isClientMode() {
        return this.clientMode;
    }

    public SSLEngineConfigurator setClientMode(boolean clientMode) {
        this.clientMode = clientMode;
        return this;
    }

    public boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    public SSLEngineConfigurator setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
        return this;
    }

    public boolean isWantClientAuth() {
        return this.wantClientAuth;
    }

    public SSLEngineConfigurator setWantClientAuth(boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
        return this;
    }

    public String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites != null ? Arrays.copyOf(this.enabledCipherSuites, this.enabledCipherSuites.length) : null;
    }

    public SSLEngineConfigurator setEnabledCipherSuites(String[] enabledCipherSuites) {
        this.enabledCipherSuites = enabledCipherSuites != null ? Arrays.copyOf(enabledCipherSuites, enabledCipherSuites.length) : null;
        return this;
    }

    public String[] getEnabledProtocols() {
        return this.enabledProtocols != null ? Arrays.copyOf(this.enabledProtocols, this.enabledProtocols.length) : null;
    }

    public SSLEngineConfigurator setEnabledProtocols(String[] enabledProtocols) {
        this.enabledProtocols = enabledProtocols != null ? Arrays.copyOf(enabledProtocols, enabledProtocols.length) : null;
        return this;
    }

    public boolean isCipherConfigured() {
        return this.isCipherConfigured;
    }

    public SSLEngineConfigurator setCipherConfigured(boolean isCipherConfigured) {
        this.isCipherConfigured = isCipherConfigured;
        return this;
    }

    public boolean isProtocolConfigured() {
        return this.isProtocolConfigured;
    }

    public SSLEngineConfigurator setProtocolConfigured(boolean isProtocolConfigured) {
        this.isProtocolConfigured = isProtocolConfigured;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLContext getSslContext() {
        if (this.sslContext == null) {
            Object object = this.sync;
            synchronized (object) {
                if (this.sslContext == null) {
                    this.sslContext = this.sslContextConfiguration.createSSLContext(true);
                }
            }
        }
        return this.sslContext;
    }

    private static String[] configureEnabledProtocols(SSLEngine sslEngine, String[] requestedProtocols) {
        String[] supportedProtocols = sslEngine.getSupportedProtocols();
        String[] protocols = null;
        ArrayList<String> list = null;
        String[] stringArray = supportedProtocols;
        int n = supportedProtocols.length;
        int n2 = 0;
        while (n2 < n) {
            String supportedProtocol = stringArray[n2];
            String[] stringArray2 = requestedProtocols;
            int n3 = requestedProtocols.length;
            int n4 = 0;
            while (n4 < n3) {
                String protocol = stringArray2[n4];
                if (supportedProtocol.equals(protocol = protocol.trim())) {
                    if (list == null) {
                        list = new ArrayList<String>();
                    }
                    list.add(protocol);
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        if (list != null) {
            protocols = list.toArray(new String[list.size()]);
        }
        return protocols;
    }

    private static String[] configureEnabledCiphers(SSLEngine sslEngine, String[] requestedCiphers) {
        String[] supportedCiphers = sslEngine.getSupportedCipherSuites();
        String[] ciphers = null;
        ArrayList<String> list = null;
        String[] stringArray = supportedCiphers;
        int n = supportedCiphers.length;
        int n2 = 0;
        while (n2 < n) {
            String supportedCipher = stringArray[n2];
            String[] stringArray2 = requestedCiphers;
            int n3 = requestedCiphers.length;
            int n4 = 0;
            while (n4 < n3) {
                String cipher = stringArray2[n4];
                if (supportedCipher.equals(cipher = cipher.trim())) {
                    if (list == null) {
                        list = new ArrayList<String>();
                    }
                    list.add(cipher);
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        if (list != null) {
            ciphers = list.toArray(new String[list.size()]);
        }
        return ciphers;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SSLEngineConfigurator");
        sb.append("{clientMode=").append(this.clientMode);
        sb.append(", enabledCipherSuites=").append(this.enabledCipherSuites == null ? "null" : Arrays.asList(this.enabledCipherSuites).toString());
        sb.append(", enabledProtocols=").append(this.enabledProtocols == null ? "null" : Arrays.asList(this.enabledProtocols).toString());
        sb.append(", needClientAuth=").append(this.needClientAuth);
        sb.append(", wantClientAuth=").append(this.wantClientAuth);
        sb.append(", isProtocolConfigured=").append(this.isProtocolConfigured);
        sb.append(", isCipherConfigured=").append(this.isCipherConfigured);
        sb.append('}');
        return sb.toString();
    }

    public SSLEngineConfigurator copy() {
        return new SSLEngineConfigurator(this);
    }
}

