/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.streams;

import java.io.EOFException;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.Transformer;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.impl.ReadyFutureImpl;
import org.glassfish.grizzly.impl.SafeFutureImpl;
import org.glassfish.grizzly.streams.Input;
import org.glassfish.grizzly.streams.Stream;
import org.glassfish.grizzly.streams.StreamDecodeCondition;
import org.glassfish.grizzly.streams.StreamReader;
import org.glassfish.grizzly.utils.CompletionHandlerAdapter;
import org.glassfish.grizzly.utils.ResultAware;
import org.glassfish.grizzly.utils.conditions.Condition;

public abstract class AbstractStreamReader
implements StreamReader {
    private static final boolean DEBUG = false;
    private static final Logger LOGGER = Grizzly.logger(AbstractStreamReader.class);
    protected final Connection connection;
    protected final Input input;
    protected final AtomicBoolean isClosed = new AtomicBoolean(false);

    private static void msg(String msg) {
        LOGGER.log(Level.INFO, "READERSTREAM:DEBUG:{0}", msg);
    }

    private static void displayBuffer(String str, Buffer wrapper) {
        AbstractStreamReader.msg(str);
        AbstractStreamReader.msg("\tposition()     = " + wrapper.position());
        AbstractStreamReader.msg("\tlimit()        = " + wrapper.limit());
        AbstractStreamReader.msg("\tcapacity()     = " + wrapper.capacity());
    }

    protected AbstractStreamReader(Connection connection, Input streamInput) {
        this.input = streamInput;
        this.connection = connection;
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.readByte() == 1;
    }

    @Override
    public byte readByte() throws IOException {
        return this.input.read();
    }

    @Override
    public char readChar() throws IOException {
        Buffer buffer;
        if (this.input.isBuffered() && (buffer = this.input.getBuffer()) != null && buffer.remaining() >= 2) {
            char result = buffer.getChar();
            buffer.shrink();
            return result;
        }
        return (char)((this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF);
    }

    @Override
    public short readShort() throws IOException {
        Buffer buffer;
        if (this.input.isBuffered() && (buffer = this.input.getBuffer()) != null && buffer.remaining() >= 2) {
            short result = buffer.getShort();
            buffer.shrink();
            return result;
        }
        return (short)((this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF);
    }

    @Override
    public int readInt() throws IOException {
        Buffer buffer;
        if (this.input.isBuffered() && (buffer = this.input.getBuffer()) != null && buffer.remaining() >= 4) {
            int result = buffer.getInt();
            buffer.shrink();
            return result;
        }
        return (this.readShort() & 0xFFFF) << 16 | this.readShort() & 0xFFFF;
    }

    @Override
    public long readLong() throws IOException {
        Buffer buffer;
        if (this.input.isBuffered() && (buffer = this.input.getBuffer()) != null && buffer.remaining() >= 8) {
            long result = buffer.getLong();
            buffer.shrink();
            return result;
        }
        return ((long)this.readInt() & 0xFFFFFFFFL) << 32 | (long)this.readInt() & 0xFFFFFFFFL;
    }

    @Override
    public final float readFloat() throws IOException {
        Buffer buffer;
        if (this.input.isBuffered() && (buffer = this.input.getBuffer()) != null && buffer.remaining() >= 4) {
            float result = buffer.getFloat();
            buffer.shrink();
            return result;
        }
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final double readDouble() throws IOException {
        Buffer buffer;
        if (this.input.isBuffered() && (buffer = this.input.getBuffer()) != null && buffer.remaining() >= 8) {
            double result = buffer.getDouble();
            buffer.shrink();
            return result;
        }
        return Double.longBitsToDouble(this.readLong());
    }

    private void arraySizeCheck(int sizeInBytes) {
        if (sizeInBytes > this.available()) {
            throw new BufferUnderflowException();
        }
    }

    @Override
    public void readBooleanArray(boolean[] data) throws IOException {
        this.arraySizeCheck(data.length);
        int ctr = 0;
        while (ctr < data.length) {
            data[ctr] = this.readBoolean();
            ++ctr;
        }
    }

    @Override
    public void readByteArray(byte[] data) throws IOException {
        this.readByteArray(data, 0, data.length);
    }

    @Override
    public void readByteArray(byte[] data, int offset, int length) throws IOException {
        this.arraySizeCheck(length);
        if (this.input.isBuffered()) {
            Buffer buffer = this.input.getBuffer();
            buffer.get(data, offset, length);
            buffer.shrink();
        } else {
            int i = offset;
            while (i < length) {
                data[i] = this.input.read();
                ++i;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void readBytes(Buffer buffer) throws IOException {
        block4: {
            if (!buffer.hasRemaining()) {
                return;
            }
            this.arraySizeCheck(buffer.remaining());
            if (!this.input.isBuffered()) ** GOTO lbl22
            inputBuffer = this.input.getBuffer();
            diff = buffer.remaining() - inputBuffer.remaining();
            if (diff >= 0) {
                buffer.put(inputBuffer);
            } else {
                save = inputBuffer.limit();
                inputBuffer.limit(save + diff);
                buffer.put(inputBuffer);
                inputBuffer.limit(save);
            }
            inputBuffer.shrink();
            break block4;
lbl-1000:
            // 1 sources

            {
                buffer.put(this.input.read());
lbl22:
                // 2 sources

                ** while (buffer.hasRemaining())
            }
        }
    }

    @Override
    public void readCharArray(char[] data) throws IOException {
        this.arraySizeCheck(2 * data.length);
        int i = 0;
        while (i < data.length) {
            data[i] = this.readChar();
            ++i;
        }
    }

    @Override
    public void readShortArray(short[] data) throws IOException {
        this.arraySizeCheck(2 * data.length);
        int i = 0;
        while (i < data.length) {
            data[i] = this.readShort();
            ++i;
        }
    }

    @Override
    public void readIntArray(int[] data) throws IOException {
        this.arraySizeCheck(4 * data.length);
        int i = 0;
        while (i < data.length) {
            data[i] = this.readInt();
            ++i;
        }
    }

    @Override
    public void readLongArray(long[] data) throws IOException {
        this.arraySizeCheck(8 * data.length);
        int i = 0;
        while (i < data.length) {
            data[i] = this.readLong();
            ++i;
        }
    }

    @Override
    public void readFloatArray(float[] data) throws IOException {
        this.arraySizeCheck(4 * data.length);
        int i = 0;
        while (i < data.length) {
            data[i] = this.readFloat();
            ++i;
        }
    }

    @Override
    public void readDoubleArray(double[] data) throws IOException {
        this.arraySizeCheck(8 * data.length);
        int i = 0;
        while (i < data.length) {
            data[i] = this.readDouble();
            ++i;
        }
    }

    @Override
    public void skip(int length) {
        this.input.skip(length);
    }

    @Override
    public <E> GrizzlyFuture<E> decode(Transformer<Stream, E> decoder) {
        return this.decode(decoder, null);
    }

    @Override
    public <E> GrizzlyFuture<E> decode(Transformer<Stream, E> decoder, CompletionHandler<E> completionHandler) {
        SafeFutureImpl future = SafeFutureImpl.create();
        DecodeCompletionHandler completionHandlerWrapper = new DecodeCompletionHandler(future, completionHandler);
        this.notifyCondition(new StreamDecodeCondition<E>(this, decoder, completionHandlerWrapper), completionHandlerWrapper);
        return future;
    }

    @Override
    public GrizzlyFuture<Integer> notifyAvailable(int size) {
        return this.notifyAvailable(size, null);
    }

    @Override
    public GrizzlyFuture<Integer> notifyAvailable(final int size, CompletionHandler<Integer> completionHandler) {
        return this.notifyCondition(new Condition(){

            @Override
            public boolean check() {
                return AbstractStreamReader.this.available() >= size;
            }
        }, completionHandler);
    }

    @Override
    public GrizzlyFuture<Integer> notifyCondition(Condition condition) {
        return this.notifyCondition(condition, null);
    }

    @Override
    public synchronized GrizzlyFuture<Integer> notifyCondition(Condition condition, CompletionHandler<Integer> completionHandler) {
        if (this.isClosed()) {
            EOFException exception = new EOFException();
            if (completionHandler != null) {
                completionHandler.failed(exception);
            }
            return ReadyFutureImpl.create(exception);
        }
        return this.input.notifyCondition(condition, completionHandler);
    }

    @Override
    public void close() {
        if (this.isClosed.compareAndSet(false, true) && this.input != null) {
            try {
                this.input.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed.get();
    }

    @Override
    public final boolean hasAvailable() {
        return this.available() > 0;
    }

    @Override
    public int available() {
        return this.input.size();
    }

    @Override
    public boolean isSupportBufferWindow() {
        return this.input.isBuffered();
    }

    @Override
    public Buffer getBufferWindow() {
        return this.input.getBuffer();
    }

    @Override
    public Buffer takeBufferWindow() {
        return this.input.takeBuffer();
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    private static class DecodeCompletionHandler<A, B>
    extends CompletionHandlerAdapter<A, B>
    implements ResultAware<A> {
        private volatile A result;

        public DecodeCompletionHandler(FutureImpl<A> future, CompletionHandler<A> completionHandler) {
            super(future, completionHandler);
        }

        @Override
        public void setResult(A result) {
            this.result = result;
        }

        @Override
        protected A adapt(B result) {
            return this.result;
        }
    }
}

