/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.streams;

import java.io.IOException;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.TransformationException;
import org.glassfish.grizzly.TransformationResult;
import org.glassfish.grizzly.Transformer;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.memory.CompositeBuffer;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.streams.BufferedInput;
import org.glassfish.grizzly.streams.Input;
import org.glassfish.grizzly.utils.conditions.Condition;

public final class TransformerInput
extends BufferedInput {
    private final Attribute<CompositeBuffer> inputBufferAttr;
    protected final Transformer<Buffer, Buffer> transformer;
    protected final Input underlyingInput;
    protected final MemoryManager memoryManager;
    protected final AttributeStorage attributeStorage;

    public TransformerInput(Transformer<Buffer, Buffer> transformer, Input underlyingInput, Connection connection) {
        this(transformer, underlyingInput, connection.getMemoryManager(), connection);
    }

    public TransformerInput(Transformer<Buffer, Buffer> transformer, Input underlyingInput, MemoryManager memoryManager, AttributeStorage attributeStorage) {
        this.transformer = transformer;
        this.underlyingInput = underlyingInput;
        this.memoryManager = memoryManager;
        this.attributeStorage = attributeStorage;
        this.inputBufferAttr = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("TransformerInput-" + transformer.getName());
    }

    @Override
    protected void onOpenInputSource() throws IOException {
        this.underlyingInput.notifyCondition(new TransformerCondition(), new TransformerCompletionHandler());
    }

    @Override
    protected void onCloseInputSource() throws IOException {
    }

    public final class TransformerCompletionHandler
    extends EmptyCompletionHandler<Integer> {
        @Override
        public void failed(Throwable throwable) {
            TransformerInput.this.notifyFailure(TransformerInput.this.completionHandler, throwable);
            TransformerInput.this.future.failure(throwable);
        }
    }

    public final class TransformerCondition
    implements Condition {
        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean check() {
            try {
                TransformationResult<Buffer, Buffer> result;
                Buffer chunkBuffer;
                boolean hasSavedBuffer;
                CompositeBuffer savedBuffer = TransformerInput.this.inputBufferAttr.get(TransformerInput.this.attributeStorage);
                Buffer bufferToTransform = savedBuffer;
                boolean bl = hasSavedBuffer = savedBuffer != null;
                if (TransformerInput.this.underlyingInput.isBuffered()) {
                    chunkBuffer = TransformerInput.this.underlyingInput.takeBuffer();
                } else {
                    int size = TransformerInput.this.underlyingInput.size();
                    chunkBuffer = TransformerInput.this.memoryManager.allocate(size);
                    while (true) {
                        if (size-- < 0) {
                            chunkBuffer.flip();
                            break;
                        }
                        chunkBuffer.put(TransformerInput.this.underlyingInput.read());
                    }
                }
                if (hasSavedBuffer) {
                    savedBuffer.append(chunkBuffer);
                } else {
                    bufferToTransform = chunkBuffer;
                }
                while (true) {
                    if (!bufferToTransform.hasRemaining()) {
                        return false;
                    }
                    result = TransformerInput.this.transformer.transform(TransformerInput.this.attributeStorage, bufferToTransform);
                    TransformationResult.Status status = result.getStatus();
                    if (status == TransformationResult.Status.COMPLETE) {
                        Buffer outputBuffer = result.getMessage();
                        TransformerInput.this.lock.writeLock().lock();
                        try {
                            TransformerInput.this.append(outputBuffer);
                            if (TransformerInput.this.isCompletionHandlerRegistered) continue;
                            return true;
                        }
                        finally {
                            TransformerInput.this.lock.writeLock().unlock();
                        }
                    }
                    if (status == TransformationResult.Status.INCOMPLETE) {
                        if (hasSavedBuffer) return false;
                        if (bufferToTransform.isComposite()) {
                            TransformerInput.this.inputBufferAttr.set(TransformerInput.this.attributeStorage, (CompositeBuffer)bufferToTransform);
                            return false;
                        }
                        savedBuffer = CompositeBuffer.newBuffer(TransformerInput.this.memoryManager);
                        savedBuffer.append(bufferToTransform);
                        TransformerInput.this.inputBufferAttr.set(TransformerInput.this.attributeStorage, savedBuffer);
                        return false;
                    }
                    if (status == TransformationResult.Status.ERROR) break;
                }
                throw new TransformationException(result.getErrorDescription());
            }
            catch (IOException e) {
                throw new TransformationException(e);
            }
        }
    }
}

