/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.threadpool;

import org.glassfish.grizzly.threadpool.AbstractThreadPool;
import org.glassfish.grizzly.threadpool.ThreadPoolProbe;

final class ProbeNotifier {
    ProbeNotifier() {
    }

    static void notifyThreadPoolStarted(AbstractThreadPool threadPool) {
        ThreadPoolProbe[] probes = threadPool.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            ThreadPoolProbe[] threadPoolProbeArray = probes;
            int n = probes.length;
            int n2 = 0;
            while (n2 < n) {
                ThreadPoolProbe probe = threadPoolProbeArray[n2];
                probe.onThreadPoolStartEvent(threadPool);
                ++n2;
            }
        }
    }

    static void notifyThreadPoolStopped(AbstractThreadPool threadPool) {
        ThreadPoolProbe[] probes = threadPool.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            ThreadPoolProbe[] threadPoolProbeArray = probes;
            int n = probes.length;
            int n2 = 0;
            while (n2 < n) {
                ThreadPoolProbe probe = threadPoolProbeArray[n2];
                probe.onThreadPoolStopEvent(threadPool);
                ++n2;
            }
        }
    }

    static void notifyThreadAllocated(AbstractThreadPool threadPool, Thread thread) {
        ThreadPoolProbe[] probes = threadPool.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            ThreadPoolProbe[] threadPoolProbeArray = probes;
            int n = probes.length;
            int n2 = 0;
            while (n2 < n) {
                ThreadPoolProbe probe = threadPoolProbeArray[n2];
                probe.onThreadAllocateEvent(threadPool, thread);
                ++n2;
            }
        }
    }

    static void notifyThreadReleased(AbstractThreadPool threadPool, Thread thread) {
        ThreadPoolProbe[] probes = threadPool.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            ThreadPoolProbe[] threadPoolProbeArray = probes;
            int n = probes.length;
            int n2 = 0;
            while (n2 < n) {
                ThreadPoolProbe probe = threadPoolProbeArray[n2];
                probe.onThreadReleaseEvent(threadPool, thread);
                ++n2;
            }
        }
    }

    static void notifyMaxNumberOfThreads(AbstractThreadPool threadPool, int maxNumberOfThreads) {
        ThreadPoolProbe[] probes = threadPool.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            ThreadPoolProbe[] threadPoolProbeArray = probes;
            int n = probes.length;
            int n2 = 0;
            while (n2 < n) {
                ThreadPoolProbe probe = threadPoolProbeArray[n2];
                probe.onMaxNumberOfThreadsEvent(threadPool, maxNumberOfThreads);
                ++n2;
            }
        }
    }

    static void notifyTaskQueued(AbstractThreadPool threadPool, Runnable task) {
        ThreadPoolProbe[] probes = threadPool.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            ThreadPoolProbe[] threadPoolProbeArray = probes;
            int n = probes.length;
            int n2 = 0;
            while (n2 < n) {
                ThreadPoolProbe probe = threadPoolProbeArray[n2];
                probe.onTaskQueueEvent(threadPool, task);
                ++n2;
            }
        }
    }

    static void notifyTaskDequeued(AbstractThreadPool threadPool, Runnable task) {
        ThreadPoolProbe[] probes = threadPool.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            ThreadPoolProbe[] threadPoolProbeArray = probes;
            int n = probes.length;
            int n2 = 0;
            while (n2 < n) {
                ThreadPoolProbe probe = threadPoolProbeArray[n2];
                probe.onTaskDequeueEvent(threadPool, task);
                ++n2;
            }
        }
    }

    static void notifyTaskCancelled(AbstractThreadPool threadPool, Runnable task) {
        ThreadPoolProbe[] probes = threadPool.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            ThreadPoolProbe[] threadPoolProbeArray = probes;
            int n = probes.length;
            int n2 = 0;
            while (n2 < n) {
                ThreadPoolProbe probe = threadPoolProbeArray[n2];
                probe.onTaskCancelEvent(threadPool, task);
                ++n2;
            }
        }
    }

    static void notifyTaskCompleted(AbstractThreadPool threadPool, Runnable task) {
        ThreadPoolProbe[] probes = threadPool.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            ThreadPoolProbe[] threadPoolProbeArray = probes;
            int n = probes.length;
            int n2 = 0;
            while (n2 < n) {
                ThreadPoolProbe probe = threadPoolProbeArray[n2];
                probe.onTaskCompleteEvent(threadPool, task);
                ++n2;
            }
        }
    }

    static void notifyTaskQueueOverflow(AbstractThreadPool threadPool) {
        ThreadPoolProbe[] probes = threadPool.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            ThreadPoolProbe[] threadPoolProbeArray = probes;
            int n = probes.length;
            int n2 = 0;
            while (n2 < n) {
                ThreadPoolProbe probe = threadPoolProbeArray[n2];
                probe.onTaskQueueOverflowEvent(threadPool);
                ++n2;
            }
        }
    }
}

