/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.utils;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;

public class Exceptions {
    public static String getStackTraceAsString(Throwable t) {
        StringWriter stringWriter = new StringWriter(2048);
        PrintWriter pw = new PrintWriter(stringWriter);
        t.printStackTrace(pw);
        pw.close();
        return stringWriter.toString();
    }

    public static IOException makeIOException(Throwable t) {
        if (IOException.class.isAssignableFrom(t.getClass())) {
            return (IOException)t;
        }
        return new IOException(t);
    }

    public static String getAllStackTracesAsString() {
        StringBuilder sb = new StringBuilder(256);
        Map<Thread, StackTraceElement[]> all = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> entry : all.entrySet()) {
            sb.append(entry.getKey()).append('\n');
            StackTraceElement[] stackTraceElementArray = entry.getValue();
            int n = stackTraceElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement traceElement = stackTraceElementArray[n2];
                sb.append("\tat ").append(traceElement).append('\n');
                ++n2;
            }
        }
        return sb.toString();
    }
}

