/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.utils;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.utils.DelayedExecutor;
import org.glassfish.grizzly.utils.NullaryFunction;

public class IdleTimeoutFilter
extends BaseFilter {
    public static final Long FOREVER = Long.MAX_VALUE;
    public static final Long FOREVER_SPECIAL = FOREVER - 1L;
    public static final String IDLE_ATTRIBUTE_NAME = "connection-idle-attribute";
    private static final Attribute<IdleRecord> IDLE_ATTR = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("connection-idle-attribute", new NullaryFunction<IdleRecord>(){

        @Override
        public IdleRecord evaluate() {
            return new IdleRecord();
        }
    });
    private final TimeoutResolver timeoutResolver;
    private final DelayedExecutor.DelayQueue<Connection> queue;
    private final DelayedExecutor.Resolver<Connection> resolver;
    private final FilterChainContext.CompletionListener contextCompletionListener = new ContextCompletionListener();

    public IdleTimeoutFilter(DelayedExecutor executor, long timeout, TimeUnit timeoutUnit) {
        this(executor, timeout, timeoutUnit, null);
    }

    public IdleTimeoutFilter(DelayedExecutor executor, TimeoutResolver timeoutResolver) {
        this(executor, timeoutResolver, null);
    }

    public IdleTimeoutFilter(DelayedExecutor executor, long timeout, TimeUnit timeUnit, TimeoutHandler handler) {
        this(executor, new DefaultWorker(handler), new IdleTimeoutResolver(IdleTimeoutFilter.convertToMillis(timeout, timeUnit)));
    }

    public IdleTimeoutFilter(DelayedExecutor executor, TimeoutResolver timeoutResolver, TimeoutHandler handler) {
        this(executor, new DefaultWorker(handler), timeoutResolver);
    }

    protected IdleTimeoutFilter(DelayedExecutor executor, DelayedExecutor.Worker<Connection> worker, TimeoutResolver timeoutResolver) {
        if (executor == null) {
            throw new IllegalArgumentException("executor cannot be null");
        }
        this.timeoutResolver = timeoutResolver;
        this.resolver = new Resolver();
        this.queue = executor.createDelayQueue(worker, this.resolver);
    }

    @Override
    public NextAction handleAccept(FilterChainContext ctx) throws IOException {
        this.queue.add(ctx.getConnection(), FOREVER, TimeUnit.MILLISECONDS);
        this.queueAction(ctx);
        return ctx.getInvokeAction();
    }

    @Override
    public NextAction handleConnect(FilterChainContext ctx) throws IOException {
        this.queue.add(ctx.getConnection(), FOREVER, TimeUnit.MILLISECONDS);
        this.queueAction(ctx);
        return ctx.getInvokeAction();
    }

    @Override
    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        this.queueAction(ctx);
        return ctx.getInvokeAction();
    }

    @Override
    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        this.queueAction(ctx);
        return ctx.getInvokeAction();
    }

    @Override
    public NextAction handleClose(FilterChainContext ctx) throws IOException {
        this.queue.remove(ctx.getConnection());
        return ctx.getInvokeAction();
    }

    public DelayedExecutor.Resolver<Connection> getResolver() {
        return this.resolver;
    }

    public static DelayedExecutor createDefaultIdleDelayedExecutor() {
        return IdleTimeoutFilter.createDefaultIdleDelayedExecutor(1000L, TimeUnit.MILLISECONDS);
    }

    public static DelayedExecutor createDefaultIdleDelayedExecutor(long checkInterval, TimeUnit checkIntervalUnit) {
        ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread newThread = new Thread(r);
                newThread.setName("Grizzly-IdleTimeoutFilter-IdleCheck");
                newThread.setDaemon(true);
                return newThread;
            }
        });
        return new DelayedExecutor(executor, checkInterval > 0L ? checkInterval : 1000L, checkIntervalUnit != null ? checkIntervalUnit : TimeUnit.MILLISECONDS);
    }

    public static void setCustomTimeout(Connection connection, long timeout, TimeUnit timeunit) {
        IDLE_ATTR.get(connection).setInitialTimeoutMillis(IdleTimeoutFilter.convertToMillis(timeout, timeunit));
    }

    protected void queueAction(FilterChainContext ctx) {
        Connection connection = ctx.getConnection();
        IdleRecord idleRecord = IDLE_ATTR.get(connection);
        if (IdleRecord.counterUpdater.getAndIncrement(idleRecord) == 0) {
            idleRecord.timeoutMillis = FOREVER;
        }
        ctx.addCompletionListener(this.contextCompletionListener);
    }

    private static long convertToMillis(long time, TimeUnit timeUnit) {
        return time >= 0L ? TimeUnit.MILLISECONDS.convert(time, timeUnit) : FOREVER.longValue();
    }

    private final class ContextCompletionListener
    implements FilterChainContext.CompletionListener {
        private ContextCompletionListener() {
        }

        @Override
        public void onComplete(FilterChainContext ctx) {
            Connection connection = ctx.getConnection();
            IdleRecord idleRecord = IDLE_ATTR.get(connection);
            idleRecord.timeoutMillis = FOREVER_SPECIAL;
            if (idleRecord.isClosed || IdleRecord.counterUpdater.decrementAndGet(idleRecord) == 0) {
                long timeoutToSet;
                if (idleRecord.isClosed) {
                    timeoutToSet = 0L;
                    IdleRecord.counterUpdater.set(idleRecord, 0);
                } else {
                    long timeout = IdleTimeoutFilter.this.timeoutResolver.getTimeout(ctx);
                    timeoutToSet = timeout == FOREVER ? FOREVER : System.currentTimeMillis() + timeout;
                }
                IdleRecord.timeoutMillisUpdater.compareAndSet(idleRecord, FOREVER_SPECIAL, timeoutToSet);
            }
        }
    }

    private static final class DefaultWorker
    implements DelayedExecutor.Worker<Connection> {
        private final TimeoutHandler handler;

        DefaultWorker(TimeoutHandler handler) {
            this.handler = handler;
        }

        @Override
        public boolean doWork(Connection connection) {
            if (connection.isOpen()) {
                if (this.handler != null) {
                    this.handler.onTimeout(connection);
                }
                connection.closeSilently();
            }
            return true;
        }
    }

    private static final class IdleRecord {
        private boolean isClosed;
        private volatile boolean isInitialSet;
        private long initialTimeoutMillis;
        private static final AtomicLongFieldUpdater<IdleRecord> timeoutMillisUpdater = AtomicLongFieldUpdater.newUpdater(IdleRecord.class, "timeoutMillis");
        private volatile long timeoutMillis;
        private static final AtomicIntegerFieldUpdater<IdleRecord> counterUpdater = AtomicIntegerFieldUpdater.newUpdater(IdleRecord.class, "counter");
        private volatile int counter;

        private IdleRecord() {
        }

        private long getInitialTimeoutMillis(long defaultTimeoutMillis) {
            return this.isInitialSet ? this.initialTimeoutMillis : defaultTimeoutMillis;
        }

        private void setInitialTimeoutMillis(long initialTimeoutMillis) {
            this.initialTimeoutMillis = initialTimeoutMillis;
            this.isInitialSet = true;
        }

        private void close() {
            this.isClosed = true;
            this.timeoutMillis = 0L;
        }
    }

    private static final class IdleTimeoutResolver
    implements TimeoutResolver {
        private final long defaultTimeoutMillis;

        IdleTimeoutResolver(long defaultTimeoutMillis) {
            this.defaultTimeoutMillis = defaultTimeoutMillis;
        }

        @Override
        public long getTimeout(FilterChainContext ctx) {
            return IDLE_ATTR.get(ctx.getConnection()).getInitialTimeoutMillis(this.defaultTimeoutMillis);
        }
    }

    private static final class Resolver
    implements DelayedExecutor.Resolver<Connection> {
        private Resolver() {
        }

        @Override
        public boolean removeTimeout(Connection connection) {
            IDLE_ATTR.get(connection).close();
            return true;
        }

        @Override
        public long getTimeoutMillis(Connection connection) {
            return IdleTimeoutFilter.IDLE_ATTR.get((AttributeStorage)connection).timeoutMillis;
        }

        @Override
        public void setTimeoutMillis(Connection connection, long timeoutMillis) {
            IdleTimeoutFilter.IDLE_ATTR.get((AttributeStorage)connection).timeoutMillis = timeoutMillis;
        }
    }

    public static interface TimeoutHandler {
        public void onTimeout(Connection var1);
    }

    public static interface TimeoutResolver {
        public long getTimeout(FilterChainContext var1);
    }
}

