/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server.http2;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.glassfish.grizzly.filterchain.FilterChainEvent;
import org.glassfish.grizzly.http.Cookie;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Session;
import org.glassfish.grizzly.http.server.http2.PushEvent;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.MimeHeaders;

public final class PushBuilder {
    private static final Header[] REMOVE_HEADERS = new Header[]{Header.Cookie, Header.ETag, Header.IfModifiedSince, Header.IfNoneMatch, Header.IfRange, Header.IfUnmodifiedSince, Header.IfMatch, Header.LastModified, Header.Referer, Header.AcceptRanges, Header.Range, Header.AcceptRanges, Header.ContentRange, Header.Authorization, Header.ProxyAuthenticate, Header.ProxyAuthorization, Header.WWWAuthenticate};
    private static final Header[] CONDITIONAL_HEADERS = new Header[]{Header.IfModifiedSince, Header.IfNoneMatch, Header.IfRange, Header.IfUnmodifiedSince, Header.IfMatch};
    String method = Method.GET.getMethodString();
    String queryString;
    String sessionId;
    MimeHeaders headers;
    String path;
    Request request;
    boolean sessionFromURL;
    List<Cookie> cookies;

    public PushBuilder(Request request) {
        Cookie c;
        int len;
        int i;
        Cookie[] responseCookies;
        this.request = request;
        this.headers = new MimeHeaders();
        this.headers.copyFrom(request.getRequest().getHeaders());
        int i2 = 0;
        int len2 = REMOVE_HEADERS.length;
        while (i2 < len2) {
            this.headers.removeHeader(REMOVE_HEADERS[i2]);
            ++i2;
        }
        this.headers.setValue(Header.Referer).setString(this.composeReferrerHeader(request));
        Session session = request.getSession(false);
        if (session != null) {
            this.sessionId = session.getIdInternal();
        }
        if (this.sessionId == null) {
            this.sessionId = request.getRequestedSessionId();
        }
        this.sessionFromURL = request.isRequestedSessionIdFromURL();
        Cookie[] requestCookies = request.getCookies();
        if (requestCookies != null) {
            this.cookies = new ArrayList<Cookie>(Arrays.asList(requestCookies));
        }
        if ((responseCookies = request.getResponse().getCookies()) != null) {
            if (this.cookies == null) {
                this.cookies = new ArrayList<Cookie>(responseCookies.length);
            }
            i = 0;
            len = responseCookies.length;
            while (i < len) {
                c = responseCookies[i];
                if (c.getMaxAge() > 0) {
                    this.cookies.add(new Cookie(c.getName(), c.getValue()));
                } else {
                    int j = 0;
                    int jlen = this.cookies.size();
                    while (j < jlen) {
                        if (this.cookies.get(j).getName().equals(c.getName())) {
                            this.cookies.remove(j);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        if (this.cookies != null && !this.cookies.isEmpty()) {
            i = 0;
            len = this.cookies.size();
            while (i < len) {
                c = this.cookies.get(i);
                this.headers.addValue(Header.Cookie).setString(c.asClientCookieString());
                ++i;
            }
        }
    }

    public PushBuilder method(String method) {
        if (method == null) {
            throw new NullPointerException();
        }
        if (Method.POST.getMethodString().equals(method) || Method.PUT.getMethodString().equals(method) || Method.DELETE.getMethodString().equals(method) || Method.CONNECT.getMethodString().equals(method) || Method.OPTIONS.getMethodString().equals(method) || Method.TRACE.getMethodString().equals(method)) {
            throw new IllegalArgumentException();
        }
        this.method = method;
        return this;
    }

    public PushBuilder queryString(String queryString) {
        this.queryString = PushBuilder.validate(queryString);
        return this;
    }

    public PushBuilder sessionId(String sessionId) {
        this.sessionId = PushBuilder.validate(sessionId);
        return this;
    }

    public PushBuilder setHeader(String name, String value) {
        if (PushBuilder.nameAndValueValid(name, value)) {
            this.headers.setValue(name).setString(value);
        }
        return this;
    }

    public PushBuilder setHeader(Header name, String value) {
        if (name != null && PushBuilder.validValue(value)) {
            this.headers.setValue(name).setString(value);
        }
        return this;
    }

    public PushBuilder addHeader(String name, String value) {
        if (PushBuilder.nameAndValueValid(name, value)) {
            this.headers.addValue(name).setString(value);
        }
        return this;
    }

    public PushBuilder addHeader(Header name, String value) {
        if (name != null && PushBuilder.validValue(value)) {
            this.headers.addValue(name).setString(value);
        }
        return this;
    }

    public PushBuilder removeHeader(String name) {
        if (PushBuilder.validValue(name) && !Header.Referer.getLowerCase().equals(name.toLowerCase())) {
            this.headers.removeHeader(name);
        }
        return this;
    }

    public PushBuilder removeHeader(Header name) {
        if (name != null && Header.Referer != name) {
            this.headers.removeHeader(name);
        }
        return this;
    }

    public PushBuilder path(String path) {
        this.path = PushBuilder.validate(path);
        return this;
    }

    public void push() {
        String pathLocal;
        if (this.path == null) {
            throw new IllegalStateException();
        }
        if (!this.request.isPushEnabled()) {
            return;
        }
        String string = pathLocal = this.path.charAt(0) == '/' ? this.path : String.valueOf(this.request.getContextPath()) + '/' + this.path;
        if (this.queryString != null) {
            pathLocal = String.valueOf(pathLocal) + (pathLocal.indexOf(63) != -1 ? String.valueOf('&') + this.queryString : String.valueOf('?') + this.queryString);
        }
        if (this.sessionId != null) {
            if (this.sessionFromURL) {
                pathLocal = String.valueOf(pathLocal) + ';' + this.request.getSessionCookieName() + '=' + this.sessionId;
            } else {
                this.headers.addValue(Header.Cookie).setString(new Cookie(this.request.getSessionCookieName(), this.sessionId).asClientCookieString());
            }
        }
        this.path = pathLocal;
        if (!this.request.getContext().getConnection().isOpen()) {
            throw new UncheckedIOException("Unable to push: connection closed", new IOException());
        }
        this.request.getContext().notifyDownstream((FilterChainEvent)PushEvent.create(this));
        this.path = null;
        int i = 0;
        int len = CONDITIONAL_HEADERS.length;
        while (i < len) {
            this.headers.removeHeader(CONDITIONAL_HEADERS[i]);
            ++i;
        }
    }

    public String getMethod() {
        return this.method;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public Iterable<String> getHeaderNames() {
        return this.headers.names();
    }

    public String getHeader(String name) {
        return this.headers.getHeader(name);
    }

    public String getPath() {
        return this.path;
    }

    private static boolean nameAndValueValid(String name, String value) {
        return PushBuilder.validValue(name) && PushBuilder.validValue(value);
    }

    private static boolean validValue(String value) {
        return value != null && !value.isEmpty();
    }

    private static String validate(String value) {
        return PushBuilder.validValue(value) ? value : null;
    }

    private String composeReferrerHeader(Request request) {
        StringBuilder sb = new StringBuilder(64);
        String queryString = request.getQueryString();
        sb.append((CharSequence)request.getRequestURL());
        if (queryString != null) {
            sb.append('?').append(queryString);
        }
        return sb.toString();
    }
}

