/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ExpandJar {
    public static String expand(URL jar) throws IOException {
        return ExpandJar.expand(jar, System.getProperty("java.io.tmpdir"));
    }

    public static String expand(URL jar, String workFolder) throws IOException {
        int slash;
        int period;
        String pathname = jar.toString().replace('\\', '/');
        if (pathname.endsWith("!/")) {
            pathname = pathname.substring(0, pathname.length() - 2);
        }
        if ((period = pathname.lastIndexOf(46)) >= pathname.length() - 4) {
            pathname = pathname.substring(0, period);
        }
        if ((slash = pathname.lastIndexOf(47)) >= 0) {
            pathname = pathname.substring(slash + 1);
        }
        return ExpandJar.expand(jar, pathname, workFolder);
    }

    public static String expand(URL jar, String pathname, String dirname) throws IOException {
        File appBase = new File(dirname);
        File docBase = new File(appBase, pathname);
        if (!docBase.mkdir()) {
            throw new IllegalStateException(String.format("Unable to create directory: %s", docBase.getAbsolutePath()));
        }
        JarURLConnection juc = (JarURLConnection)jar.openConnection();
        juc.setUseCaches(false);
        JarFile jarFile = null;
        InputStream input = null;
        try {
            try {
                jarFile = juc.getJarFile();
                Enumeration<JarEntry> jarEntries = jarFile.entries();
                while (jarEntries.hasMoreElements()) {
                    File parent;
                    JarEntry jarEntry = jarEntries.nextElement();
                    String name = jarEntry.getName();
                    int last = name.lastIndexOf(47);
                    if (last >= 0 && !(parent = new File(docBase, name.substring(0, last))).mkdirs()) {
                        throw new IllegalStateException(String.format("Unable to create directory: %s", parent.getAbsolutePath()));
                    }
                    if (name.endsWith("/")) continue;
                    input = jarFile.getInputStream(jarEntry);
                    ExpandJar.expand(input, docBase, name);
                    input.close();
                    input = null;
                }
            }
            catch (IOException e) {
                ExpandJar.deleteDir(docBase);
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Throwable throwable2) {}
                input = null;
            }
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable3) {}
                jarFile = null;
            }
            throw throwable;
        }
        if (input != null) {
            try {
                input.close();
            }
            catch (Throwable throwable) {}
            input = null;
        }
        if (jarFile != null) {
            try {
                jarFile.close();
            }
            catch (Throwable throwable) {}
            jarFile = null;
        }
        return docBase.getAbsolutePath();
    }

    public static boolean copy(File src, File dest) {
        String[] files;
        boolean result = true;
        if (src.isDirectory()) {
            files = src.list();
            result = dest.mkdir();
        } else {
            files = new String[]{""};
        }
        if (files == null) {
            files = new String[]{};
        }
        int i = 0;
        while (i < files.length && result) {
            block29: {
                File fileSrc = new File(src, files[i]);
                File fileDest = new File(dest, files[i]);
                if (fileSrc.isDirectory()) {
                    result = ExpandJar.copy(fileSrc, fileDest);
                } else {
                    FileChannel ic = null;
                    AbstractInterruptibleChannel oc = null;
                    try {
                        try {
                            ic = new FileInputStream(fileSrc).getChannel();
                            oc = new FileOutputStream(fileDest).getChannel();
                            ic.transferTo(0L, ic.size(), (WritableByteChannel)((Object)oc));
                        }
                        catch (IOException iOException) {
                            result = false;
                            if (ic != null) {
                                try {
                                    ic.close();
                                }
                                catch (IOException iOException2) {}
                            }
                            if (oc != null) {
                                try {
                                    oc.close();
                                }
                                catch (IOException iOException3) {}
                            }
                            break block29;
                        }
                    }
                    catch (Throwable throwable) {
                        if (ic != null) {
                            try {
                                ic.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (oc != null) {
                            try {
                                oc.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (ic != null) {
                        try {
                            ic.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (oc != null) {
                        try {
                            oc.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            ++i;
        }
        return result;
    }

    public static boolean delete(File dir) {
        if (dir.isDirectory()) {
            return ExpandJar.deleteDir(dir);
        }
        return dir.delete();
    }

    public static boolean deleteDir(File dir) {
        String[] files = dir.list();
        if (files == null) {
            files = new String[]{};
        }
        int i = 0;
        while (i < files.length) {
            File file = new File(dir, files[i]);
            if (file.isDirectory()) {
                ExpandJar.deleteDir(file);
            } else if (!file.delete()) {
                throw new IllegalStateException(String.format("Unable to delete file: %s", file.getAbsolutePath()));
            }
            ++i;
        }
        return dir.delete();
    }

    protected static void expand(InputStream input, File docBase, String name) throws IOException {
        File file = new File(docBase, name);
        FilterOutputStream output = null;
        try {
            int n;
            output = new BufferedOutputStream(new FileOutputStream(file));
            byte[] buffer = new byte[2048];
            while ((n = input.read(buffer)) > 0) {
                ((BufferedOutputStream)output).write(buffer, 0, n);
            }
        }
        catch (Throwable throwable) {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (output != null) {
            try {
                output.close();
            }
            catch (IOException iOException) {}
        }
    }
}

