/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http;

import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpBrokenContentException;
import org.glassfish.grizzly.http.HttpCodecFilter;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpPacketParsing;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.HttpTrailer;
import org.glassfish.grizzly.http.ParsingResult;
import org.glassfish.grizzly.http.TransferEncoding;
import org.glassfish.grizzly.http.util.Ascii;
import org.glassfish.grizzly.http.util.HexUtils;
import org.glassfish.grizzly.http.util.HttpCodecUtils;
import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.CompositeBuffer;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.utils.Charsets;

public final class ChunkedTransferEncoding
implements TransferEncoding {
    private static final int MAX_HTTP_CHUNK_SIZE_LENGTH = 16;
    private static final long CHUNK_SIZE_OVERFLOW = 0x7FFFFFFFFFFFFFFL;
    private static final int CHUNK_LENGTH_PARSED_STATE = 3;
    private static final byte[] LAST_CHUNK_CRLF_BYTES = "0\r\n".getBytes(Charsets.ASCII_CHARSET);
    private static final int[] DEC = HexUtils.getDecBytes();
    private final int maxHeadersSize;

    public ChunkedTransferEncoding(int maxHeadersSize) {
        this.maxHeadersSize = maxHeadersSize;
    }

    @Override
    public boolean wantDecode(HttpHeader httpPacket) {
        return httpPacket.isChunked();
    }

    @Override
    public boolean wantEncode(HttpHeader httpPacket) {
        return httpPacket.isChunked();
    }

    @Override
    public void prepareSerialize(FilterChainContext ctx, HttpHeader httpHeader, HttpContent content) {
        httpHeader.makeTransferEncodingHeader("chunked");
    }

    @Override
    public ParsingResult parsePacket(FilterChainContext ctx, HttpHeader httpPacket, Buffer buffer) {
        HttpPacketParsing httpPacketParsing = (HttpPacketParsing)((Object)httpPacket);
        HttpCodecFilter.ContentParsingState contentParsingState = httpPacketParsing.getContentParsingState();
        boolean isLastChunk = contentParsingState.isLastChunk;
        if (!isLastChunk && contentParsingState.chunkRemainder <= 0L) {
            if ((buffer = ChunkedTransferEncoding.parseTrailerCRLF(httpPacketParsing, buffer)) == null) {
                return ParsingResult.create(null, null);
            }
            if (!ChunkedTransferEncoding.parseHttpChunkLength(httpPacketParsing, buffer)) {
                if (ChunkedTransferEncoding.isHeadRequest(httpPacket)) {
                    return ParsingResult.create(httpPacket.httpTrailerBuilder().headers(contentParsingState.trailerHeaders).build(), null);
                }
                return ParsingResult.create(null, buffer, false);
            }
        } else {
            contentParsingState.chunkContentStart = 0;
        }
        int chunkContentStart = contentParsingState.chunkContentStart;
        if (contentParsingState.chunkLength == 0L) {
            if (!isLastChunk) {
                contentParsingState.isLastChunk = true;
                isLastChunk = true;
                this.initTrailerParsing(httpPacketParsing);
            }
            if (!this.parseLastChunkTrailer(ctx, httpPacket, httpPacketParsing, buffer)) {
                return ParsingResult.create(null, buffer);
            }
            chunkContentStart = httpPacketParsing.getHeaderParsingState().offset;
        }
        long thisPacketRemaining = contentParsingState.chunkRemainder;
        int contentAvailable = buffer.limit() - chunkContentStart;
        Buffer remainder = null;
        if ((long)contentAvailable > thisPacketRemaining) {
            remainder = buffer.split((int)((long)chunkContentStart + thisPacketRemaining));
            buffer.position(chunkContentStart);
        } else if (chunkContentStart > 0) {
            buffer.position(chunkContentStart);
        }
        if (isLastChunk) {
            return ParsingResult.create(httpPacket.httpTrailerBuilder().headers(contentParsingState.trailerHeaders).build(), remainder);
        }
        buffer.shrink();
        if (buffer.hasRemaining()) {
            contentParsingState.chunkRemainder -= (long)buffer.remaining();
        } else {
            buffer.tryDispose();
            buffer = Buffers.EMPTY_BUFFER;
        }
        return ParsingResult.create(((HttpContent.Builder)httpPacket.httpContentBuilder().content(buffer)).build(), remainder);
    }

    @Override
    public Buffer serializePacket(FilterChainContext ctx, HttpContent httpContent) {
        return ChunkedTransferEncoding.encodeHttpChunk(ctx.getMemoryManager(), httpContent, httpContent.isLast());
    }

    private void initTrailerParsing(HttpPacketParsing httpPacket) {
        int start;
        HttpCodecFilter.HeaderParsingState headerParsingState = httpPacket.getHeaderParsingState();
        HttpCodecFilter.ContentParsingState contentParsingState = httpPacket.getContentParsingState();
        headerParsingState.subState = 0;
        headerParsingState.start = start = contentParsingState.chunkContentStart;
        headerParsingState.offset = start;
        headerParsingState.packetLimit = start + this.maxHeadersSize;
    }

    private boolean parseLastChunkTrailer(FilterChainContext ctx, HttpHeader httpHeader, HttpPacketParsing httpPacket, Buffer input) {
        HttpCodecFilter.HeaderParsingState headerParsingState = httpPacket.getHeaderParsingState();
        HttpCodecFilter.ContentParsingState contentParsingState = httpPacket.getContentParsingState();
        HttpCodecFilter filter = headerParsingState.codecFilter;
        boolean result = filter.parseHeadersFromBuffer(httpHeader, contentParsingState.trailerHeaders, headerParsingState, input);
        if (result) {
            if (contentParsingState.trailerHeaders.size() > 0) {
                filter.onHttpHeadersParsed(httpHeader, contentParsingState.trailerHeaders, ctx);
            }
        } else {
            headerParsingState.checkOverflow(input.limit(), "The chunked encoding trailer header is too large");
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean parseHttpChunkLength(HttpPacketParsing httpPacket, Buffer input) {
        HttpCodecFilter.HeaderParsingState parsingState = httpPacket.getHeaderParsingState();
        while (true) {
            switch (parsingState.state) {
                case 0: {
                    int pos;
                    parsingState.start = pos = input.position();
                    parsingState.offset = pos;
                    parsingState.packetLimit = pos + 16;
                }
                case 1: {
                    int nonSpaceIdx = HttpCodecUtils.skipSpaces(input, parsingState.offset, parsingState.packetLimit);
                    if (nonSpaceIdx == -1) {
                        parsingState.offset = input.limit();
                        parsingState.state = 1;
                        parsingState.checkOverflow(input.limit(), "The chunked encoding length prefix is too large");
                        return false;
                    }
                    parsingState.offset = nonSpaceIdx;
                    parsingState.state = 2;
                }
                case 2: {
                    int offset = parsingState.offset;
                    int limit = Math.min(parsingState.packetLimit, input.limit());
                    long value = parsingState.parsingNumericValue;
                    while (offset < limit) {
                        byte b = input.get(offset);
                        if (HttpCodecUtils.isSpaceOrTab(b) || b == 13 || b == 59) {
                            parsingState.checkpoint = offset;
                        } else {
                            if (b == 10) {
                                HttpCodecFilter.ContentParsingState contentParsingState = httpPacket.getContentParsingState();
                                contentParsingState.chunkContentStart = offset + 1;
                                contentParsingState.chunkLength = value;
                                contentParsingState.chunkRemainder = value;
                                parsingState.state = 3;
                                return true;
                            }
                            if (parsingState.checkpoint != -1) throw new HttpBrokenContentException("Unexpected HTTP chunk header");
                            if (DEC[b & 0xFF] == -1 || !ChunkedTransferEncoding.checkOverflow(value)) throw new HttpBrokenContentException("Invalid byte representing a hex value within a chunk length encountered : " + b);
                            value = (value << 4) + (long)DEC[b & 0xFF];
                        }
                        ++offset;
                    }
                    parsingState.parsingNumericValue = value;
                    parsingState.offset = limit;
                    parsingState.checkOverflow(limit, "The chunked encoding length prefix is too large");
                    return false;
                }
            }
        }
    }

    private static boolean checkOverflow(long value) {
        return value <= 0x7FFFFFFFFFFFFFFL;
    }

    private static boolean isHeadRequest(HttpHeader header) {
        HttpRequestPacket request = header.isRequest() ? (HttpRequestPacket)header : ((HttpResponsePacket)header).getRequest();
        return request.isHeadRequest();
    }

    private static Buffer parseTrailerCRLF(HttpPacketParsing httpPacket, Buffer input) {
        HttpCodecFilter.HeaderParsingState parsingState = httpPacket.getHeaderParsingState();
        if (parsingState.state == 3) {
            while (input.hasRemaining()) {
                if (input.get() != 10) continue;
                parsingState.recycle();
                if (input.hasRemaining()) {
                    return input.slice();
                }
                return null;
            }
            return null;
        }
        return input;
    }

    private static Buffer encodeHttpChunk(MemoryManager memoryManager, HttpContent httpContent, boolean isLastChunk) {
        Buffer httpChunkTrailer;
        boolean hasContent;
        Buffer content = httpContent.getContent();
        Buffer httpChunkBuffer = memoryManager.allocate(16);
        int chunkSize = content.remaining();
        Ascii.intToHexString(httpChunkBuffer, chunkSize);
        httpChunkBuffer = HttpCodecUtils.put(memoryManager, httpChunkBuffer, HttpCodecFilter.CRLF_BYTES);
        httpChunkBuffer.trim();
        httpChunkBuffer.allowBufferDispose(true);
        boolean bl = hasContent = chunkSize > 0;
        if (hasContent && (httpChunkBuffer = Buffers.appendBuffers((MemoryManager)memoryManager, (Buffer)httpChunkBuffer, (Buffer)content)).isComposite()) {
            httpChunkBuffer.allowBufferDispose(true);
            ((CompositeBuffer)httpChunkBuffer).allowInternalBuffersDispose(true);
            ((CompositeBuffer)httpChunkBuffer).disposeOrder(CompositeBuffer.DisposeOrder.FIRST_TO_LAST);
        }
        if (!isLastChunk) {
            httpChunkTrailer = memoryManager.allocate(2);
        } else {
            boolean isTrailer = HttpTrailer.isTrailer(httpContent) && ((HttpTrailer)httpContent).getHeaders().size() > 0;
            httpChunkTrailer = !isTrailer ? memoryManager.allocate(8) : memoryManager.allocate(256);
            if (hasContent) {
                httpChunkTrailer = HttpCodecUtils.put(memoryManager, httpChunkTrailer, HttpCodecFilter.CRLF_BYTES);
                httpChunkTrailer = HttpCodecUtils.put(memoryManager, httpChunkTrailer, LAST_CHUNK_CRLF_BYTES);
            }
            if (isTrailer) {
                HttpTrailer httpTrailer = (HttpTrailer)httpContent;
                MimeHeaders mimeHeaders = httpTrailer.getHeaders();
                httpChunkTrailer = HttpCodecFilter.encodeMimeHeaders(memoryManager, httpChunkTrailer, mimeHeaders, httpContent.getHttpHeader().getTempHeaderEncodingBuffer());
            }
        }
        httpChunkTrailer = HttpCodecUtils.put(memoryManager, httpChunkTrailer, HttpCodecFilter.CRLF_BYTES);
        httpChunkTrailer.trim();
        httpChunkTrailer.allowBufferDispose(true);
        return Buffers.appendBuffers((MemoryManager)memoryManager, (Buffer)httpChunkBuffer, (Buffer)httpChunkTrailer);
    }
}

