/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http;

import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.TransformationResult;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.compression.zip.GZipDecoder;
import org.glassfish.grizzly.compression.zip.GZipEncoder;
import org.glassfish.grizzly.http.ContentEncoding;
import org.glassfish.grizzly.http.EncodingFilter;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.ParsingResult;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;

public class GZipContentEncoding
implements ContentEncoding {
    public static final int DEFAULT_IN_BUFFER_SIZE = 512;
    public static final int DEFAULT_OUT_BUFFER_SIZE = 512;
    private static final String[] ALIASES = new String[]{"gzip", "deflate"};
    public static final String NAME = "gzip";
    private final GZipDecoder decoder;
    private final GZipEncoder encoder;
    private final EncodingFilter encoderFilter;

    public GZipContentEncoding() {
        this(512, 512);
    }

    public GZipContentEncoding(int inBufferSize, int outBufferSize) {
        this(inBufferSize, outBufferSize, null);
    }

    public GZipContentEncoding(int inBufferSize, int outBufferSize, EncodingFilter encoderFilter) {
        this.decoder = new GZipDecoder(inBufferSize);
        this.encoder = new GZipEncoder(outBufferSize);
        this.encoderFilter = encoderFilter != null ? encoderFilter : new EncodingFilter(){

            @Override
            public boolean applyEncoding(HttpHeader httpPacket) {
                return false;
            }

            @Override
            public boolean applyDecoding(HttpHeader httpPacket) {
                return true;
            }
        };
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String[] getAliases() {
        return (String[])ALIASES.clone();
    }

    public static String[] getGzipAliases() {
        return (String[])ALIASES.clone();
    }

    @Override
    public final boolean wantDecode(HttpHeader header) {
        return this.encoderFilter.applyDecoding(header);
    }

    @Override
    public final boolean wantEncode(HttpHeader header) {
        return this.encoderFilter.applyEncoding(header);
    }

    @Override
    public ParsingResult decode(Connection connection, HttpContent httpContent) {
        Buffer input;
        HttpHeader httpHeader = httpContent.getHttpHeader();
        TransformationResult result = this.decoder.transform((AttributeStorage)httpHeader, (Object)(input = httpContent.getContent()));
        Buffer remainder = (Buffer)result.getExternalRemainder();
        if (remainder == null || !remainder.hasRemaining()) {
            input.tryDispose();
            remainder = null;
        } else {
            input.shrink();
        }
        try {
            switch (result.getStatus()) {
                case COMPLETE: {
                    httpContent.setContent((Buffer)result.getMessage());
                    ParsingResult parsingResult = ParsingResult.create(httpContent, remainder);
                    return parsingResult;
                }
                case INCOMPLETE: {
                    ParsingResult parsingResult = ParsingResult.create(null, remainder);
                    return parsingResult;
                }
                case ERROR: {
                    throw new IllegalStateException("GZip decode error. Code: " + result.getErrorCode() + " Description: " + result.getErrorDescription());
                }
            }
            throw new IllegalStateException("Unexpected status: " + result.getStatus());
        }
        finally {
            result.recycle();
        }
    }

    @Override
    public HttpContent encode(Connection connection, HttpContent httpContent) {
        HttpHeader httpHeader = httpContent.getHttpHeader();
        Buffer input = httpContent.getContent();
        boolean isLast = httpContent.isLast();
        if (!isLast && !input.hasRemaining()) {
            return httpContent;
        }
        TransformationResult result = this.encoder.transform((AttributeStorage)httpHeader, (Object)input);
        input.tryDispose();
        try {
            switch (result.getStatus()) {
                case COMPLETE: 
                case INCOMPLETE: {
                    Buffer encodedBuffer = (Buffer)result.getMessage();
                    if (isLast) {
                        Buffer finishBuffer = this.encoder.finish((AttributeStorage)httpHeader);
                        encodedBuffer = Buffers.appendBuffers((MemoryManager)connection.getMemoryManager(), (Buffer)encodedBuffer, (Buffer)finishBuffer);
                    }
                    if (encodedBuffer != null) {
                        httpContent.setContent(encodedBuffer);
                        HttpContent httpContent2 = httpContent;
                        return httpContent2;
                    }
                    return null;
                }
                case ERROR: {
                    throw new IllegalStateException("GZip decode error. Code: " + result.getErrorCode() + " Description: " + result.getErrorDescription());
                }
            }
            throw new IllegalStateException("Unexpected status: " + result.getStatus());
        }
        finally {
            result.recycle();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GZipContentEncoding other = (GZipContentEncoding)obj;
        return this.getName().equals(other.getName());
    }

    public int hashCode() {
        int hash = 3;
        hash = 53 * hash + this.getName().hashCode();
        return hash;
    }
}

