/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.util;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class StringManager {
    private ResourceBundle bundle;
    private static final Map<String, StringManager> managers = new HashMap<String, StringManager>();

    private StringManager(String packageName, ClassLoader loader) {
        this(packageName, Locale.getDefault(), loader);
    }

    private StringManager(String packageName, Locale loc, ClassLoader loader) {
        String bundleName = String.valueOf(packageName) + ".LocalStrings";
        try {
            this.bundle = ResourceBundle.getBundle(bundleName, loc, loader);
        }
        catch (MissingResourceException missingResourceException) {
            this.bundle = ResourceBundle.getBundle(bundleName, Locale.US, loader);
        }
    }

    private StringManager(ResourceBundle bundle) {
        this.bundle = bundle;
    }

    public String getString(String key) {
        String str;
        if (key == null) {
            String msg = "key may not have a null value";
            throw new IllegalArgumentException(msg);
        }
        try {
            str = this.bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            str = null;
        }
        return str;
    }

    /*
     * Unable to fully structure code
     */
    public String getString(String key, Object[] args) {
        block8: {
            value = this.getString(key);
            try {
                if (args == null) {
                    args = new Object[1];
                }
                nonNullArgs = args;
                i = 0;
                while (i < args.length) {
                    if (args[i] == null) {
                        if (nonNullArgs == args) {
                            nonNullArgs = (Object[])args.clone();
                        }
                        nonNullArgs[i] = "null";
                    }
                    ++i;
                }
                if (value == null) {
                    value = key;
                }
                iString = MessageFormat.format(value, nonNullArgs);
                break block8;
            }
            catch (IllegalArgumentException v0) {
                buf = new StringBuilder();
                buf.append(value);
                i = 0;
                ** while (i < args.length)
            }
lbl-1000:
            // 1 sources

            {
                buf.append(" arg[").append(i).append("]=").append(args[i]);
                ++i;
                continue;
            }
lbl28:
            // 1 sources

            iString = buf.toString();
        }
        return iString;
    }

    public String getString(String key, Object arg) {
        Object[] args = new Object[]{arg};
        return this.getString(key, args);
    }

    public String getString(String key, Object arg1, Object arg2) {
        Object[] args = new Object[]{arg1, arg2};
        return this.getString(key, args);
    }

    public String getString(String key, Object arg1, Object arg2, Object arg3) {
        Object[] args = new Object[]{arg1, arg2, arg3};
        return this.getString(key, args);
    }

    public String getString(String key, Object arg1, Object arg2, Object arg3, Object arg4) {
        Object[] args = new Object[]{arg1, arg2, arg3, arg4};
        return this.getString(key, args);
    }

    public static synchronized StringManager getManager(String packageName, ClassLoader loader) {
        StringManager mgr = managers.get(packageName);
        if (mgr == null) {
            mgr = new StringManager(packageName, loader);
            managers.put(packageName, mgr);
        }
        return mgr;
    }

    public static synchronized StringManager getManager(ResourceBundle bundle) {
        return new StringManager(bundle);
    }

    public static synchronized StringManager getManager(String packageName, Locale loc, ClassLoader loader) {
        StringManager mgr = managers.get(String.valueOf(packageName) + '_' + loc.toString());
        if (mgr == null) {
            mgr = new StringManager(packageName, loc, loader);
            managers.put(String.valueOf(packageName) + '_' + loc.toString(), mgr);
        }
        return mgr;
    }
}

