/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.internal;

import java.net.URL;
import org.glassfish.hk2.utilities.reflection.Pretty;

class DelegatingClassLoader
extends ClassLoader {
    private final ClassLoader[] delegates;

    DelegatingClassLoader(ClassLoader parent, ClassLoader ... classLoaderDelegates) {
        super(parent);
        this.delegates = classLoaderDelegates;
    }

    @Override
    public Class<?> loadClass(String clazz) throws ClassNotFoundException {
        if (this.getParent() != null) {
            try {
                return this.getParent().loadClass(clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        ClassNotFoundException firstFail = null;
        ClassLoader[] classLoaderArray = this.delegates;
        int n = this.delegates.length;
        int n2 = 0;
        while (n2 < n) {
            ClassLoader delegate = classLoaderArray[n2];
            try {
                return delegate.loadClass(clazz);
            }
            catch (ClassNotFoundException ncfe) {
                if (firstFail == null) {
                    firstFail = ncfe;
                }
                ++n2;
            }
        }
        if (firstFail != null) {
            throw firstFail;
        }
        throw new ClassNotFoundException("Could not find " + clazz);
    }

    @Override
    public URL getResource(String resource) {
        URL u;
        if (this.getParent() != null && (u = this.getParent().getResource(resource)) != null) {
            return u;
        }
        ClassLoader[] classLoaderArray = this.delegates;
        int n = this.delegates.length;
        int n2 = 0;
        while (n2 < n) {
            ClassLoader delegate = classLoaderArray[n2];
            URL u2 = delegate.getResource(resource);
            if (u2 != null) {
                return u2;
            }
            ++n2;
        }
        return null;
    }

    public String toString() {
        return "DelegatingClassLoader(" + this.getParent() + "," + Pretty.array((Object[])this.delegates) + "," + System.identityHashCode(this) + ")";
    }
}

