/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.grizzly2.httpserver;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.TimeoutHandler;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyRequestPropertiesDelegate;
import org.glassfish.jersey.grizzly2.httpserver.internal.LocalizationMessages;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.Binder;
import org.glassfish.jersey.internal.inject.ReferencingFactory;
import org.glassfish.jersey.internal.inject.SupplierClassBinding;
import org.glassfish.jersey.internal.inject.SupplierInstanceBinding;
import org.glassfish.jersey.internal.util.ExtendedLogger;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.ContainerException;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.ServerProperties;
import org.glassfish.jersey.server.internal.ContainerUtils;
import org.glassfish.jersey.server.spi.Container;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;

public final class GrizzlyHttpContainer
extends HttpHandler
implements Container {
    private static final ExtendedLogger logger = new ExtendedLogger(Logger.getLogger(GrizzlyHttpContainer.class.getName()), Level.FINEST);
    private final Type RequestTYPE = new GenericType<Ref<Request>>(){}.getType();
    private final Type ResponseTYPE = new GenericType<Ref<Response>>(){}.getType();
    private boolean configSetStatusOverSendError;
    private boolean configReduceContextPathSlashesEnabled;
    private static final CompletionHandler<Response> EMPTY_COMPLETION_HANDLER = new CompletionHandler<Response>(){

        public void cancelled() {
        }

        public void failed(Throwable throwable) {
        }

        public void completed(Response result) {
        }

        public void updated(Response result) {
        }
    };
    private volatile ApplicationHandler appHandler;

    GrizzlyHttpContainer(Application application) {
        this.appHandler = new ApplicationHandler(application, (Binder)new GrizzlyBinder());
        this.cacheConfigSetStatusOverSendError();
        this.cacheConfigEnableLeadingContextPathSlashes();
    }

    GrizzlyHttpContainer(Application application, Object parentContext) {
        this.appHandler = new ApplicationHandler(application, (Binder)new GrizzlyBinder(), parentContext);
        this.cacheConfigSetStatusOverSendError();
        this.cacheConfigEnableLeadingContextPathSlashes();
    }

    public void start() {
        super.start();
        this.appHandler.onStartup((Container)this);
    }

    public void service(Request request, Response response) {
        ResponseWriter responseWriter = new ResponseWriter(response, this.configSetStatusOverSendError);
        try {
            logger.debugLog("GrizzlyHttpContainer.service(...) started");
            URI baseUri = this.getBaseUri(request);
            URI requestUri = this.getRequestUri(request);
            ContainerRequest requestContext = new ContainerRequest(baseUri, requestUri, request.getMethod().getMethodString(), this.getSecurityContext(request), (PropertiesDelegate)new GrizzlyRequestPropertiesDelegate(request), (Configuration)this.appHandler.getConfiguration());
            requestContext.setEntityStream(request.getInputStream());
            for (String headerName : request.getHeaderNames()) {
                requestContext.headers(headerName, request.getHeaders(headerName));
            }
            requestContext.setWriter((ContainerResponseWriter)responseWriter);
            requestContext.setRequestScopedInitializer(injectionManager -> {
                ((Ref)injectionManager.getInstance(this.RequestTYPE)).set((Object)request);
                ((Ref)injectionManager.getInstance(this.ResponseTYPE)).set((Object)response);
            });
            this.appHandler.handle(requestContext);
        }
        finally {
            logger.debugLog("GrizzlyHttpContainer.service(...) finished");
        }
    }

    private boolean containsContextPath(Request request) {
        return request.getContextPath() != null && request.getContextPath().length() > 0;
    }

    public ResourceConfig getConfiguration() {
        return this.appHandler.getConfiguration();
    }

    public void reload() {
        this.reload(this.appHandler.getConfiguration());
    }

    public void reload(ResourceConfig configuration) {
        this.appHandler.onShutdown((Container)this);
        this.appHandler = new ApplicationHandler((Application)configuration, (Binder)new GrizzlyBinder());
        this.appHandler.onReload((Container)this);
        this.appHandler.onStartup((Container)this);
        this.cacheConfigSetStatusOverSendError();
        this.cacheConfigEnableLeadingContextPathSlashes();
    }

    public ApplicationHandler getApplicationHandler() {
        return this.appHandler;
    }

    public void destroy() {
        super.destroy();
        this.appHandler.onShutdown((Container)this);
        this.appHandler = null;
    }

    private SecurityContext getSecurityContext(final Request request) {
        return new SecurityContext(){

            public boolean isUserInRole(String role) {
                return false;
            }

            public boolean isSecure() {
                return request.isSecure();
            }

            public Principal getUserPrincipal() {
                return request.getUserPrincipal();
            }

            public String getAuthenticationScheme() {
                return request.getAuthType();
            }
        };
    }

    private URI getBaseUri(Request request) {
        try {
            return new URI(request.getScheme(), null, request.getServerName(), request.getServerPort(), this.getBasePath(request), null, null);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private String getBasePath(Request request) {
        String contextPath = request.getContextPath();
        if (contextPath == null || contextPath.isEmpty()) {
            return "/";
        }
        if (contextPath.charAt(contextPath.length() - 1) != '/') {
            return String.valueOf(contextPath) + "/";
        }
        return contextPath;
    }

    private URI getRequestUri(Request request) {
        try {
            String serverAddress = this.getServerAddress(request);
            String uri = this.configReduceContextPathSlashesEnabled && this.containsContextPath(request) ? ContainerUtils.reduceLeadingSlashes((String)request.getRequestURI()) : request.getRequestURI();
            String queryString = request.getQueryString();
            if (queryString != null) {
                uri = String.valueOf(uri) + "?" + ContainerUtils.encodeUnsafeCharacters((String)queryString);
            }
            return new URI(String.valueOf(serverAddress) + uri);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private String getServerAddress(Request request) throws URISyntaxException {
        return new URI(request.getScheme(), null, request.getServerName(), request.getServerPort(), null, null, null).toString();
    }

    private void cacheConfigSetStatusOverSendError() {
        this.configSetStatusOverSendError = (Boolean)ServerProperties.getValue((Map)this.getConfiguration().getProperties(), (String)"jersey.config.server.response.setStatusOverSendError", (Object)false, Boolean.class);
    }

    private void cacheConfigEnableLeadingContextPathSlashes() {
        this.configReduceContextPathSlashesEnabled = (Boolean)ServerProperties.getValue((Map)this.getConfiguration().getProperties(), (String)"jersey.config.server.reduceContextPathSlashes.enabled", (Object)false, Boolean.class);
    }

    static class GrizzlyBinder
    extends AbstractBinder {
        GrizzlyBinder() {
        }

        protected void configure() {
            ((SupplierClassBinding)((SupplierClassBinding)this.bindFactory(GrizzlyRequestReferencingFactory.class).to(Request.class)).proxy(false)).in(RequestScoped.class);
            ((SupplierInstanceBinding)this.bindFactory(ReferencingFactory.referenceFactory()).to((GenericType)new GenericType<Ref<Request>>(){})).in(RequestScoped.class);
            ((SupplierClassBinding)((SupplierClassBinding)((SupplierClassBinding)this.bindFactory(GrizzlyResponseReferencingFactory.class).to(Response.class)).proxy(true)).proxyForSameScope(false)).in(RequestScoped.class);
            ((SupplierInstanceBinding)this.bindFactory(ReferencingFactory.referenceFactory()).to((GenericType)new GenericType<Ref<Response>>(){})).in(RequestScoped.class);
        }
    }

    private static class GrizzlyRequestReferencingFactory
    extends ReferencingFactory<Request> {
        @Inject
        public GrizzlyRequestReferencingFactory(Provider<Ref<Request>> referenceFactory) {
            super(referenceFactory);
        }
    }

    private static class GrizzlyResponseReferencingFactory
    extends ReferencingFactory<Response> {
        @Inject
        public GrizzlyResponseReferencingFactory(Provider<Ref<Response>> referenceFactory) {
            super(referenceFactory);
        }
    }

    private static final class ResponseWriter
    implements ContainerResponseWriter {
        private final String name;
        private final Response grizzlyResponse;
        private final boolean configSetStatusOverSendError;

        ResponseWriter(Response response, boolean configSetStatusOverSendError) {
            this.grizzlyResponse = response;
            this.configSetStatusOverSendError = configSetStatusOverSendError;
            if (logger.isDebugLoggable()) {
                this.name = "ResponseWriter {id=" + UUID.randomUUID().toString() + ", grizzlyResponse=" + this.grizzlyResponse.hashCode() + '}';
                logger.debugLog("{0} - init", new Object[]{this.name});
            } else {
                this.name = "ResponseWriter";
            }
        }

        public String toString() {
            return this.name;
        }

        public void commit() {
            try {
                if (this.grizzlyResponse.isSuspended()) {
                    this.grizzlyResponse.resume();
                }
            }
            catch (Throwable throwable) {
                logger.debugLog("{0} - commit() called", new Object[]{this.name});
                throw throwable;
            }
            logger.debugLog("{0} - commit() called", new Object[]{this.name});
        }

        public boolean suspend(long timeOut, TimeUnit timeUnit, final ContainerResponseWriter.TimeoutHandler timeoutHandler) {
            try {
                this.grizzlyResponse.suspend(timeOut, timeUnit, EMPTY_COMPLETION_HANDLER, new TimeoutHandler(){

                    public boolean onTimeout(Response response) {
                        if (timeoutHandler != null) {
                            timeoutHandler.onTimeout((ContainerResponseWriter)this);
                        }
                        return false;
                    }
                });
            }
            catch (IllegalStateException illegalStateException) {
                try {}
                catch (Throwable throwable) {
                    logger.debugLog("{0} - suspend(...) called", new Object[]{this.name});
                    throw throwable;
                }
                logger.debugLog("{0} - suspend(...) called", new Object[]{this.name});
                return false;
            }
            logger.debugLog("{0} - suspend(...) called", new Object[]{this.name});
            return true;
        }

        public void setSuspendTimeout(long timeOut, TimeUnit timeUnit) throws IllegalStateException {
            try {
                this.grizzlyResponse.getSuspendContext().setTimeout(timeOut, timeUnit);
            }
            catch (Throwable throwable) {
                logger.debugLog("{0} - setTimeout(...) called", new Object[]{this.name});
                throw throwable;
            }
            logger.debugLog("{0} - setTimeout(...) called", new Object[]{this.name});
        }

        public OutputStream writeResponseStatusAndHeaders(long contentLength, ContainerResponse context) throws ContainerException {
            OutputStream outputStream;
            try {
                Response.StatusType statusInfo = context.getStatusInfo();
                if (statusInfo.getReasonPhrase() == null) {
                    this.grizzlyResponse.setStatus(statusInfo.getStatusCode());
                } else {
                    this.grizzlyResponse.setStatus(statusInfo.getStatusCode(), statusInfo.getReasonPhrase());
                }
                this.grizzlyResponse.setContentLengthLong(contentLength);
                for (Map.Entry e : context.getStringHeaders().entrySet()) {
                    for (String value : (List)e.getValue()) {
                        this.grizzlyResponse.addHeader((String)e.getKey(), value);
                    }
                }
                outputStream = this.grizzlyResponse.getOutputStream();
            }
            catch (Throwable throwable) {
                logger.debugLog("{0} - writeResponseStatusAndHeaders() called", new Object[]{this.name});
                throw throwable;
            }
            logger.debugLog("{0} - writeResponseStatusAndHeaders() called", new Object[]{this.name});
            return outputStream;
        }

        public void failure(Throwable error) {
            block7: {
                try {
                    if (this.grizzlyResponse.isCommitted()) break block7;
                    try {
                        if (this.configSetStatusOverSendError) {
                            this.grizzlyResponse.reset();
                            this.grizzlyResponse.setStatus(500, "Request failed.");
                        } else {
                            this.grizzlyResponse.sendError(500, "Request failed.");
                        }
                    }
                    catch (IllegalStateException ex) {
                        logger.log(Level.FINER, "Unable to reset failed response.", (Throwable)ex);
                    }
                    catch (IOException ex) {
                        throw new ContainerException(LocalizationMessages.EXCEPTION_SENDING_ERROR_RESPONSE(500, "Request failed."), (Throwable)ex);
                    }
                }
                catch (Throwable throwable) {
                    logger.debugLog("{0} - failure(...) called", new Object[]{this.name});
                    this.rethrow(error);
                    throw throwable;
                }
            }
            logger.debugLog("{0} - failure(...) called", new Object[]{this.name});
            this.rethrow(error);
        }

        public boolean enableResponseBuffering() {
            return true;
        }

        private void rethrow(Throwable error) {
            if (error instanceof RuntimeException) {
                throw (RuntimeException)error;
            }
            throw new ContainerException(error);
        }
    }
}

