/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.server.model.AnnotatedMethod;

public final class MethodList
implements Iterable<AnnotatedMethod> {
    private AnnotatedMethod[] methods;

    public MethodList(Class<?> c) {
        this(c, false);
    }

    public MethodList(Class<?> c, boolean declaredMethods) {
        this(declaredMethods ? MethodList.getAllDeclaredMethods(c) : MethodList.getMethods(c));
    }

    private static List<Method> getAllDeclaredMethods(Class<?> c) {
        ArrayList<Method> l = new ArrayList<Method>();
        while (c != null && c != Object.class) {
            l.addAll((Collection)AccessController.doPrivileged(ReflectionHelper.getDeclaredMethodsPA(c)));
            c = c.getSuperclass();
        }
        return l;
    }

    private static List<Method> getMethods(Class<?> c) {
        return Arrays.asList(c.getMethods());
    }

    public MethodList(Collection<Method> methods) {
        ArrayList<AnnotatedMethod> l = new ArrayList<AnnotatedMethod>(methods.size());
        for (Method m : methods) {
            if (m.isSynthetic() || m.getDeclaringClass() == Object.class) continue;
            l.add(new AnnotatedMethod(m));
        }
        this.methods = new AnnotatedMethod[l.size()];
        this.methods = l.toArray(this.methods);
    }

    public MethodList(Method ... methods) {
        this(Arrays.asList(methods));
    }

    public MethodList(AnnotatedMethod ... methods) {
        this.methods = methods;
    }

    @Override
    public Iterator<AnnotatedMethod> iterator() {
        return Arrays.asList(this.methods).iterator();
    }

    public MethodList isNotPublic() {
        return this.filter(new Filter(){

            @Override
            public boolean keep(AnnotatedMethod m) {
                return !Modifier.isPublic(m.getMethod().getModifiers());
            }
        });
    }

    public MethodList hasNumParams(final int paramCount) {
        return this.filter(new Filter(){

            @Override
            public boolean keep(AnnotatedMethod m) {
                return m.getParameterTypes().length == paramCount;
            }
        });
    }

    public MethodList hasReturnType(final Class<?> returnType) {
        return this.filter(new Filter(){

            @Override
            public boolean keep(AnnotatedMethod m) {
                return m.getMethod().getReturnType() == returnType;
            }
        });
    }

    public MethodList nameStartsWith(final String prefix) {
        return this.filter(new Filter(){

            @Override
            public boolean keep(AnnotatedMethod m) {
                return m.getMethod().getName().startsWith(prefix);
            }
        });
    }

    public <T extends Annotation> MethodList withAnnotation(final Class<T> annotation) {
        return this.filter(new Filter(){

            @Override
            public boolean keep(AnnotatedMethod m) {
                return m.getAnnotation(annotation) != null;
            }
        });
    }

    public <T extends Annotation> MethodList withMetaAnnotation(final Class<T> annotation) {
        return this.filter(new Filter(){

            @Override
            public boolean keep(AnnotatedMethod m) {
                Annotation[] annotationArray = m.getAnnotations();
                int n = annotationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Annotation a = annotationArray[n2];
                    if (a.annotationType().getAnnotation(annotation) != null) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        });
    }

    public <T extends Annotation> MethodList withoutAnnotation(final Class<T> annotation) {
        return this.filter(new Filter(){

            @Override
            public boolean keep(AnnotatedMethod m) {
                return m.getAnnotation(annotation) == null;
            }
        });
    }

    public <T extends Annotation> MethodList withoutMetaAnnotation(final Class<T> annotation) {
        return this.filter(new Filter(){

            @Override
            public boolean keep(AnnotatedMethod m) {
                Annotation[] annotationArray = m.getAnnotations();
                int n = annotationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Annotation a = annotationArray[n2];
                    if (a.annotationType().getAnnotation(annotation) != null) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
        });
    }

    public MethodList filter(Filter filter) {
        ArrayList<AnnotatedMethod> result = new ArrayList<AnnotatedMethod>();
        AnnotatedMethod[] annotatedMethodArray = this.methods;
        int n = this.methods.length;
        int n2 = 0;
        while (n2 < n) {
            AnnotatedMethod m = annotatedMethodArray[n2];
            if (filter.keep(m)) {
                result.add(m);
            }
            ++n2;
        }
        return new MethodList(result.toArray(new AnnotatedMethod[result.size()]));
    }

    public static interface Filter {
        public boolean keep(AnnotatedMethod var1);
    }
}

