/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedAction;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import javax.validation.ValidationException;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.message.internal.TracingLogger;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.SubjectSecurityContext;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.internal.ServerTraceEvent;
import org.glassfish.jersey.server.internal.inject.ConfiguredValidator;
import org.glassfish.jersey.server.internal.process.MappableException;
import org.glassfish.jersey.server.model.Invocable;
import org.glassfish.jersey.server.spi.internal.ResourceMethodDispatcher;

abstract class AbstractJavaResourceMethodDispatcher
implements ResourceMethodDispatcher {
    private final Method method;
    private final InvocationHandler methodHandler;
    private final Invocable resourceMethod;
    private final ConfiguredValidator validator;

    AbstractJavaResourceMethodDispatcher(Invocable resourceMethod, InvocationHandler methodHandler, ConfiguredValidator validator) {
        this.method = resourceMethod.getDefinitionMethod();
        this.methodHandler = methodHandler;
        this.resourceMethod = resourceMethod;
        this.validator = validator;
    }

    @Override
    public final Response dispatch(Object resource, ContainerRequest request) throws ProcessingException {
        Response response = null;
        try {
            response = this.doDispatch(resource, request);
        }
        catch (Throwable throwable) {
            TracingLogger.getInstance((PropertiesDelegate)request).log((TracingLogger.Event)ServerTraceEvent.DISPATCH_RESPONSE, new Object[]{response});
            throw throwable;
        }
        TracingLogger.getInstance((PropertiesDelegate)request).log((TracingLogger.Event)ServerTraceEvent.DISPATCH_RESPONSE, new Object[]{response});
        return response;
    }

    protected abstract Response doDispatch(Object var1, ContainerRequest var2) throws ProcessingException;

    final Object invoke(final ContainerRequest containerRequest, final Object resource, final Object ... args) throws ProcessingException {
        try {
            Object invocationResult;
            if (this.validator != null) {
                this.validator.validateResourceAndInputParams(resource, this.resourceMethod, args);
            }
            PrivilegedAction invokeMethodAction = new PrivilegedAction(){

                /*
                 * Unable to fully structure code
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public Object run() {
                    block12: {
                        tracingLogger = TracingLogger.getInstance((PropertiesDelegate)containerRequest);
                        timestamp = tracingLogger.timestamp((TracingLogger.Event)ServerTraceEvent.METHOD_INVOKE);
                        result = AbstractJavaResourceMethodDispatcher.this.methodHandler.invoke(resource, AbstractJavaResourceMethodDispatcher.this.method, args);
                        if (!(result instanceof CompletionStage)) ** GOTO lbl26
                        try {
                            resultFuture = ((CompletionStage)result).toCompletableFuture();
                        }
                        catch (UnsupportedOperationException v0) {
                            var8_8 = result;
                            tracingLogger.logDuration((TracingLogger.Event)ServerTraceEvent.METHOD_INVOKE, timestamp, new Object[]{resource, AbstractJavaResourceMethodDispatcher.this.method});
                            return var8_8;
                        }
                        if (resultFuture == null || !resultFuture.isDone()) ** GOTO lbl26
                        if (!resultFuture.isCancelled()) break block12;
                        var8_9 = Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
                        tracingLogger.logDuration((TracingLogger.Event)ServerTraceEvent.METHOD_INVOKE, timestamp, new Object[]{resource, AbstractJavaResourceMethodDispatcher.this.method});
                        return var8_9;
                    }
                    try {
                        var8_10 = resultFuture.get();
                    }
                    catch (ExecutionException e) {
                        try {
                            throw new InvocationTargetException(e.getCause());
lbl26:
                            // 2 sources

                            var8_11 = result;
                        }
                        catch (IllegalAccessException | IllegalArgumentException | UndeclaredThrowableException ex) {
                            try {
                                throw new ProcessingException(LocalizationMessages.ERROR_RESOURCE_JAVA_METHOD_INVOCATION(), (Throwable)ex);
                                catch (InvocationTargetException ex) {
                                    throw AbstractJavaResourceMethodDispatcher.mapTargetToRuntimeEx(ex.getCause());
                                }
                                catch (Throwable t) {
                                    throw new ProcessingException(t);
                                }
                            }
                            catch (Throwable var7_13) {
                                tracingLogger.logDuration((TracingLogger.Event)ServerTraceEvent.METHOD_INVOKE, timestamp, new Object[]{resource, AbstractJavaResourceMethodDispatcher.this.method});
                                throw var7_13;
                            }
                        }
                        tracingLogger.logDuration((TracingLogger.Event)ServerTraceEvent.METHOD_INVOKE, timestamp, new Object[]{resource, AbstractJavaResourceMethodDispatcher.this.method});
                        return var8_11;
                    }
                    tracingLogger.logDuration((TracingLogger.Event)ServerTraceEvent.METHOD_INVOKE, timestamp, new Object[]{resource, AbstractJavaResourceMethodDispatcher.this.method});
                    return var8_10;
                }
            };
            SecurityContext securityContext = containerRequest.getSecurityContext();
            Object object = invocationResult = securityContext instanceof SubjectSecurityContext ? ((SubjectSecurityContext)securityContext).doAsSubject(invokeMethodAction) : invokeMethodAction.run();
            if (this.validator != null) {
                this.validator.validateResult(resource, this.resourceMethod, invocationResult);
            }
            return invocationResult;
        }
        catch (ValidationException ex) {
            throw new MappableException(ex);
        }
    }

    private static RuntimeException mapTargetToRuntimeEx(Throwable throwable) {
        if (throwable instanceof WebApplicationException) {
            return (WebApplicationException)throwable;
        }
        return new MappableException(throwable);
    }

    public String toString() {
        return this.method.toString();
    }
}

