/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.annotations.common.reflection.java;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.annotations.common.Version;
import org.hibernate.annotations.common.reflection.AnnotationReader;
import org.hibernate.annotations.common.reflection.ClassLoaderDelegate;
import org.hibernate.annotations.common.reflection.ClassLoadingException;
import org.hibernate.annotations.common.reflection.MetadataProvider;
import org.hibernate.annotations.common.reflection.MetadataProviderInjector;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XMethod;
import org.hibernate.annotations.common.reflection.XPackage;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.annotations.common.reflection.java.JavaMetadataProvider;
import org.hibernate.annotations.common.reflection.java.JavaXAnnotatedElement;
import org.hibernate.annotations.common.reflection.java.JavaXArrayType;
import org.hibernate.annotations.common.reflection.java.JavaXClass;
import org.hibernate.annotations.common.reflection.java.JavaXCollectionType;
import org.hibernate.annotations.common.reflection.java.JavaXMethod;
import org.hibernate.annotations.common.reflection.java.JavaXPackage;
import org.hibernate.annotations.common.reflection.java.JavaXProperty;
import org.hibernate.annotations.common.reflection.java.JavaXSimpleType;
import org.hibernate.annotations.common.reflection.java.JavaXType;
import org.hibernate.annotations.common.reflection.java.Pair;
import org.hibernate.annotations.common.reflection.java.generics.IdentityTypeEnvironment;
import org.hibernate.annotations.common.reflection.java.generics.TypeEnvironment;
import org.hibernate.annotations.common.reflection.java.generics.TypeEnvironmentFactory;
import org.hibernate.annotations.common.reflection.java.generics.TypeSwitch;
import org.hibernate.annotations.common.reflection.java.generics.TypeUtils;
import org.hibernate.annotations.common.util.ReflectHelper;
import org.hibernate.annotations.common.util.StandardClassLoaderDelegateImpl;
import org.hibernate.annotations.common.util.impl.LoggerFactory;

public class JavaReflectionManager
implements ReflectionManager,
MetadataProviderInjector {
    private MetadataProvider metadataProvider;
    private ClassLoaderDelegate classLoaderDelegate = StandardClassLoaderDelegateImpl.INSTANCE;
    private final Map<TypeKey, JavaXClass> xClasses = new HashMap<TypeKey, JavaXClass>();
    private final Map<Package, JavaXPackage> packagesToXPackages = new HashMap<Package, JavaXPackage>();
    private final Map<MemberKey, JavaXProperty> xProperties = new HashMap<MemberKey, JavaXProperty>();
    private final Map<MemberKey, JavaXMethod> xMethods = new HashMap<MemberKey, JavaXMethod>();
    private final TypeEnvironmentFactory typeEnvs = new TypeEnvironmentFactory();

    static {
        LoggerFactory.make(Version.class.getName()).version(Version.getVersionString());
    }

    @Override
    public MetadataProvider getMetadataProvider() {
        if (this.metadataProvider == null) {
            this.setMetadataProvider(new JavaMetadataProvider());
        }
        return this.metadataProvider;
    }

    @Override
    public void setMetadataProvider(MetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
    }

    @Override
    public void injectClassLoaderDelegate(ClassLoaderDelegate delegate) {
        this.classLoaderDelegate = delegate == null ? StandardClassLoaderDelegateImpl.INSTANCE : delegate;
    }

    @Override
    public ClassLoaderDelegate getClassLoaderDelegate() {
        return this.classLoaderDelegate;
    }

    public XClass toXClass(Class clazz) {
        return this.toXClass(clazz, IdentityTypeEnvironment.INSTANCE);
    }

    @Override
    public Class toClass(XClass xClazz) {
        if (!(xClazz instanceof JavaXClass)) {
            throw new IllegalArgumentException("XClass not coming from this ReflectionManager implementation");
        }
        return (Class)((JavaXClass)xClazz).toAnnotatedElement();
    }

    @Override
    public Method toMethod(XMethod xMethod) {
        if (!(xMethod instanceof JavaXMethod)) {
            throw new IllegalArgumentException("XMethod not coming from this ReflectionManager implementation");
        }
        return (Method)((JavaXAnnotatedElement)((Object)xMethod)).toAnnotatedElement();
    }

    @Deprecated
    public XClass classForName(String name, Class caller) throws ClassNotFoundException {
        return this.toXClass(ReflectHelper.classForName(name, caller));
    }

    @Override
    public XClass classForName(String name) throws ClassLoadingException {
        return this.toXClass(this.getClassLoaderDelegate().classForName(name));
    }

    @Override
    public XPackage packageForName(String packageName) throws ClassNotFoundException {
        return this.getXAnnotatedElement(this.getClassLoaderDelegate().classForName(String.valueOf(packageName) + ".package-info").getPackage());
    }

    XClass toXClass(Type t, final TypeEnvironment context) {
        return (XClass)new TypeSwitch<XClass>(){

            @Override
            public XClass caseClass(Class classType) {
                TypeKey key = new TypeKey(classType, context);
                JavaXClass result = JavaReflectionManager.this.xClasses.get(key);
                if (result == null) {
                    result = new JavaXClass(classType, context, JavaReflectionManager.this);
                    JavaReflectionManager.this.xClasses.put(key, result);
                }
                return result;
            }

            @Override
            public XClass caseParameterizedType(ParameterizedType parameterizedType) {
                return JavaReflectionManager.this.toXClass(parameterizedType.getRawType(), JavaReflectionManager.this.typeEnvs.getEnvironment(parameterizedType, context));
            }
        }.doSwitch(context.bind(t));
    }

    XPackage getXAnnotatedElement(Package pkg) {
        JavaXPackage xPackage = this.packagesToXPackages.get(pkg);
        if (xPackage == null) {
            xPackage = new JavaXPackage(pkg, this);
            this.packagesToXPackages.put(pkg, xPackage);
        }
        return xPackage;
    }

    XProperty getXProperty(Member member, TypeEnvironment context) {
        MemberKey key = new MemberKey(member, context);
        JavaXProperty xProperty = this.xProperties.get(key);
        if (xProperty == null) {
            xProperty = JavaXProperty.create(member, context, this);
            this.xProperties.put(key, xProperty);
        }
        return xProperty;
    }

    XMethod getXMethod(Member member, TypeEnvironment context) {
        MemberKey key = new MemberKey(member, context);
        JavaXMethod xMethod = this.xMethods.get(key);
        if (xMethod == null) {
            xMethod = JavaXMethod.create(member, context, this);
            this.xMethods.put(key, xMethod);
        }
        return xMethod;
    }

    TypeEnvironment getTypeEnvironment(Type t) {
        return (TypeEnvironment)new TypeSwitch<TypeEnvironment>(){

            @Override
            public TypeEnvironment caseClass(Class classType) {
                return JavaReflectionManager.this.typeEnvs.getEnvironment(classType);
            }

            @Override
            public TypeEnvironment caseParameterizedType(ParameterizedType parameterizedType) {
                return JavaReflectionManager.this.typeEnvs.getEnvironment(parameterizedType);
            }

            @Override
            public TypeEnvironment defaultCase(Type type) {
                return IdentityTypeEnvironment.INSTANCE;
            }
        }.doSwitch(t);
    }

    public JavaXType toXType(TypeEnvironment context, Type propType) {
        Type boundType = this.toApproximatingEnvironment(context).bind(propType);
        if (TypeUtils.isArray(boundType)) {
            return new JavaXArrayType(propType, context, this);
        }
        if (TypeUtils.isCollection(boundType)) {
            return new JavaXCollectionType(propType, context, this);
        }
        if (TypeUtils.isSimple(boundType)) {
            return new JavaXSimpleType(propType, context, this);
        }
        throw new IllegalArgumentException("No PropertyTypeExtractor available for type void ");
    }

    public boolean equals(XClass class1, Class class2) {
        if (class1 == null) {
            return class2 == null;
        }
        return ((JavaXClass)class1).toClass().equals(class2);
    }

    public TypeEnvironment toApproximatingEnvironment(TypeEnvironment context) {
        return this.typeEnvs.toApproximatingEnvironment(context);
    }

    @Override
    public AnnotationReader buildAnnotationReader(AnnotatedElement annotatedElement) {
        return this.getMetadataProvider().getAnnotationReader(annotatedElement);
    }

    @Override
    public Map getDefaults() {
        return this.getMetadataProvider().getDefaults();
    }

    private static class MemberKey
    extends Pair<Member, TypeEnvironment> {
        MemberKey(Member member, TypeEnvironment context) {
            super(member, context);
        }
    }

    private static class TypeKey
    extends Pair<Type, TypeEnvironment> {
        TypeKey(Type t, TypeEnvironment context) {
            super(t, context);
        }
    }
}

