/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.annotations.common.reflection.java;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.annotations.common.reflection.Filter;
import org.hibernate.annotations.common.reflection.ReflectionUtil;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XMethod;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.annotations.common.reflection.java.JavaReflectionManager;
import org.hibernate.annotations.common.reflection.java.JavaXAnnotatedElement;
import org.hibernate.annotations.common.reflection.java.generics.CompoundTypeEnvironment;
import org.hibernate.annotations.common.reflection.java.generics.TypeEnvironment;

class JavaXClass
extends JavaXAnnotatedElement
implements XClass {
    private final TypeEnvironment context;
    private final Class clazz;

    public JavaXClass(Class clazz, TypeEnvironment env, JavaReflectionManager factory) {
        super(clazz, factory);
        this.clazz = clazz;
        this.context = env;
    }

    @Override
    public String getName() {
        return this.toClass().getName();
    }

    @Override
    public XClass getSuperclass() {
        return this.getFactory().toXClass(this.toClass().getSuperclass(), CompoundTypeEnvironment.create(this.getTypeEnvironment(), this.getFactory().getTypeEnvironment(this.toClass())));
    }

    @Override
    public XClass[] getInterfaces() {
        Class<?>[] classes = this.toClass().getInterfaces();
        int length = classes.length;
        XClass[] xClasses = new XClass[length];
        if (length != 0) {
            TypeEnvironment environment = CompoundTypeEnvironment.create(this.getTypeEnvironment(), this.getFactory().getTypeEnvironment(this.toClass()));
            int index = 0;
            while (index < length) {
                xClasses[index] = this.getFactory().toXClass(classes[index], environment);
                ++index;
            }
        }
        return xClasses;
    }

    @Override
    public boolean isInterface() {
        return this.toClass().isInterface();
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this.toClass().getModifiers());
    }

    @Override
    public boolean isPrimitive() {
        return this.toClass().isPrimitive();
    }

    @Override
    public boolean isEnum() {
        return this.toClass().isEnum();
    }

    private List<XProperty> getDeclaredFieldProperties(Filter filter) {
        LinkedList<XProperty> result = new LinkedList<XProperty>();
        Field[] fieldArray = this.toClass().getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            if (ReflectionUtil.isProperty(f, this.getTypeEnvironment().bind(f.getGenericType()), filter)) {
                result.add(this.getFactory().getXProperty(f, this.getTypeEnvironment()));
            }
            ++n2;
        }
        return result;
    }

    private List<XProperty> getDeclaredMethodProperties(Filter filter) {
        LinkedList<XProperty> result = new LinkedList<XProperty>();
        Method[] methodArray = this.toClass().getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (ReflectionUtil.isProperty(m, this.getTypeEnvironment().bind(m.getGenericReturnType()), filter)) {
                result.add(this.getFactory().getXProperty(m, this.getTypeEnvironment()));
            }
            ++n2;
        }
        return result;
    }

    @Override
    public List<XProperty> getDeclaredProperties(String accessType) {
        return this.getDeclaredProperties(accessType, XClass.DEFAULT_FILTER);
    }

    @Override
    public List<XProperty> getDeclaredProperties(String accessType, Filter filter) {
        if (accessType.equals("field")) {
            return this.getDeclaredFieldProperties(filter);
        }
        if (accessType.equals("property")) {
            return this.getDeclaredMethodProperties(filter);
        }
        throw new IllegalArgumentException("Unknown access type " + accessType);
    }

    @Override
    public List<XMethod> getDeclaredMethods() {
        LinkedList<XMethod> result = new LinkedList<XMethod>();
        Method[] methodArray = this.toClass().getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            result.add(this.getFactory().getXMethod(m, this.getTypeEnvironment()));
            ++n2;
        }
        return result;
    }

    public Class<?> toClass() {
        return this.clazz;
    }

    @Override
    public boolean isAssignableFrom(XClass c) {
        return this.toClass().isAssignableFrom(((JavaXClass)c).toClass());
    }

    boolean isArray() {
        return this.toClass().isArray();
    }

    TypeEnvironment getTypeEnvironment() {
        return this.context;
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

