/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.archive.internal;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.hibernate.boot.archive.spi.AbstractArchiveDescriptor;
import org.hibernate.boot.archive.spi.ArchiveContext;
import org.hibernate.boot.archive.spi.ArchiveDescriptorFactory;
import org.hibernate.boot.archive.spi.ArchiveEntry;
import org.hibernate.boot.archive.spi.ArchiveEntryHandler;
import org.hibernate.boot.archive.spi.ArchiveException;
import org.hibernate.boot.archive.spi.InputStreamAccess;
import org.hibernate.internal.log.UrlMessageBundle;

public class JarFileBasedArchiveDescriptor
extends AbstractArchiveDescriptor {
    public JarFileBasedArchiveDescriptor(ArchiveDescriptorFactory archiveDescriptorFactory, URL archiveUrl, String entry) {
        super(archiveDescriptorFactory, archiveUrl, entry);
    }

    @Override
    public void visitArchive(ArchiveContext context) {
        JarFile jarFile = this.resolveJarFileReference();
        if (jarFile == null) {
            return;
        }
        try {
            Enumeration<JarEntry> zipEntries = jarFile.entries();
            while (zipEntries.hasMoreElements()) {
                InputStreamAccess inputStreamAccess;
                ZipEntry subZipEntry22;
                Object jarInputStream;
                ZipEntry zipEntry = zipEntries.nextElement();
                String entryName = this.extractName(zipEntry);
                if (this.getEntryBasePrefix() != null && !entryName.startsWith(this.getEntryBasePrefix()) || zipEntry.isDirectory()) continue;
                if (entryName.equals(this.getEntryBasePrefix())) {
                    try {
                        Throwable throwable = null;
                        Object var7_9 = null;
                        try {
                            BufferedInputStream is = new BufferedInputStream(jarFile.getInputStream(zipEntry));
                            try {
                                jarInputStream = new JarInputStream(is);
                                try {
                                    subZipEntry22 = ((JarInputStream)jarInputStream).getNextEntry();
                                    while (subZipEntry22 != null) {
                                        if (!subZipEntry22.isDirectory()) {
                                            final String name = this.extractName(subZipEntry22);
                                            final String relativeName = this.extractRelativeName(subZipEntry22);
                                            final InputStreamAccess inputStreamAccess2 = this.buildByteBasedInputStreamAccess(name, (InputStream)jarInputStream);
                                            ArchiveEntry entry = new ArchiveEntry(){

                                                @Override
                                                public String getName() {
                                                    return name;
                                                }

                                                @Override
                                                public String getNameWithinArchive() {
                                                    return relativeName;
                                                }

                                                @Override
                                                public InputStreamAccess getStreamAccess() {
                                                    return inputStreamAccess2;
                                                }
                                            };
                                            ArchiveEntryHandler entryHandler = context.obtainArchiveEntryHandler(entry);
                                            entryHandler.handleEntry(entry, context);
                                        }
                                        subZipEntry22 = ((JarInputStream)jarInputStream).getNextEntry();
                                    }
                                }
                                finally {
                                    if (jarInputStream != null) {
                                        ((ZipInputStream)jarInputStream).close();
                                    }
                                }
                                if (is == null) continue;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                if (is != null) {
                                    ((InputStream)is).close();
                                }
                                throw throwable;
                            }
                            ((InputStream)is).close();
                            continue;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception e) {
                        throw new ArchiveException("Error accessing JarFile entry [" + zipEntry.getName() + "]", e);
                    }
                }
                final String name = this.extractName(zipEntry);
                final String relativeName = this.extractRelativeName(zipEntry);
                try {
                    jarInputStream = null;
                    subZipEntry22 = null;
                    try (InputStream is = jarFile.getInputStream(zipEntry);){
                        inputStreamAccess = this.buildByteBasedInputStreamAccess(name, is);
                    }
                    catch (Throwable subZipEntry22) {
                        if (jarInputStream == null) {
                            jarInputStream = subZipEntry22;
                        } else if (jarInputStream != subZipEntry22) {
                            ((Throwable)jarInputStream).addSuppressed(subZipEntry22);
                        }
                        throw jarInputStream;
                    }
                }
                catch (IOException iOException) {
                    throw new ArchiveException(String.format("Unable to access stream from jar file [%s] for entry [%s]", jarFile.getName(), zipEntry.getName()));
                }
                ArchiveEntry entry = new ArchiveEntry(){

                    @Override
                    public String getName() {
                        return name;
                    }

                    @Override
                    public String getNameWithinArchive() {
                        return relativeName;
                    }

                    @Override
                    public InputStreamAccess getStreamAccess() {
                        return inputStreamAccess;
                    }
                };
                ArchiveEntryHandler entryHandler = context.obtainArchiveEntryHandler(entry);
                entryHandler.handleEntry(entry, context);
            }
        }
        catch (Throwable throwable) {
            try {
                jarFile.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            jarFile.close();
        }
        catch (Exception exception) {}
    }

    private JarFile resolveJarFileReference() {
        try {
            String filePart = this.getArchiveUrl().getFile();
            if (filePart != null && filePart.indexOf(32) != -1) {
                return new JarFile(this.getArchiveUrl().getFile());
            }
            return new JarFile(this.getArchiveUrl().toURI().getSchemeSpecificPart());
        }
        catch (IOException e) {
            UrlMessageBundle.URL_LOGGER.logUnableToFindFileByUrl(this.getArchiveUrl(), e);
        }
        catch (URISyntaxException e) {
            UrlMessageBundle.URL_LOGGER.logMalformedUrl(this.getArchiveUrl(), e);
        }
        return null;
    }
}

