/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.jaxb.internal;

import java.io.IOException;
import java.io.InputStream;
import org.hibernate.boot.InvalidMappingException;
import org.hibernate.boot.jaxb.Origin;
import org.hibernate.boot.jaxb.spi.Binder;
import org.hibernate.boot.jaxb.spi.Binding;
import org.hibernate.boot.jaxb.spi.XmlSource;
import org.hibernate.internal.CoreLogging;
import org.jboss.logging.Logger;

public class InputStreamXmlSource
extends XmlSource {
    private static final Logger log = CoreLogging.logger(InputStreamXmlSource.class);
    private final InputStream inputStream;
    private final boolean autoClose;

    public InputStreamXmlSource(Origin origin, InputStream inputStream, boolean autoClose) {
        super(origin);
        this.inputStream = inputStream;
        this.autoClose = autoClose;
    }

    @Override
    public Binding doBind(Binder binder) {
        return InputStreamXmlSource.doBind(binder, this.inputStream, this.getOrigin(), this.autoClose);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Binding doBind(Binder binder, InputStream inputStream, Origin origin, boolean autoClose) {
        Binding binding;
        try {
            binding = binder.bind(inputStream, origin);
            if (!autoClose) return binding;
        }
        catch (Exception e) {
            try {
                throw new InvalidMappingException(origin, (Throwable)e);
            }
            catch (Throwable throwable) {
                if (!autoClose) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    log.trace((Object)"Was unable to close input stream");
                }
                throw throwable;
            }
        }
        try {
            inputStream.close();
            return binding;
        }
        catch (IOException iOException) {
            log.trace((Object)"Was unable to close input stream");
        }
        return binding;
    }
}

