/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.internal.javassist;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import org.hibernate.HibernateException;
import org.hibernate.bytecode.enhance.internal.javassist.CompositeEnhancer;
import org.hibernate.bytecode.enhance.internal.javassist.EntityEnhancer;
import org.hibernate.bytecode.enhance.internal.javassist.FieldWriter;
import org.hibernate.bytecode.enhance.internal.javassist.JavassistEnhancementContext;
import org.hibernate.bytecode.enhance.internal.javassist.MappedSuperclassEnhancer;
import org.hibernate.bytecode.enhance.internal.javassist.PersistentAttributesEnhancer;
import org.hibernate.bytecode.enhance.internal.javassist.PersistentAttributesHelper;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.bytecode.enhance.spi.EnhancementException;
import org.hibernate.bytecode.enhance.spi.Enhancer;
import org.hibernate.engine.spi.Managed;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;

public class EnhancerImpl
implements Enhancer {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(Enhancer.class);
    protected final JavassistEnhancementContext enhancementContext;
    private final ClassPool classPool;

    public EnhancerImpl(EnhancementContext enhancementContext) {
        this.enhancementContext = new JavassistEnhancementContext(enhancementContext);
        this.classPool = this.buildClassPool(this.enhancementContext);
    }

    EnhancerImpl(JavassistEnhancementContext enhancementContext) {
        this.enhancementContext = enhancementContext;
        this.classPool = this.buildClassPool(enhancementContext);
    }

    @Override
    public synchronized byte[] enhance(String className, byte[] originalBytes) throws EnhancementException {
        CtClass managedCtClass = null;
        try {
            managedCtClass = this.classPool.makeClassIfNew((InputStream)new ByteArrayInputStream(originalBytes));
            byte[] byArray = this.enhance(managedCtClass) ? this.getByteCode(managedCtClass) : null;
            return byArray;
        }
        catch (IOException iOException) {
            log.unableToBuildEnhancementMetamodel(className);
            return null;
        }
        finally {
            if (managedCtClass != null) {
                managedCtClass.detach();
            }
        }
    }

    private ClassPool buildClassPool(final JavassistEnhancementContext enhancementContext) {
        ClassPool classPool = new ClassPool(false){

            public ClassLoader getClassLoader() {
                return enhancementContext.getLoadingClassLoader();
            }
        };
        ClassLoader loadingClassLoader = enhancementContext.getLoadingClassLoader();
        if (loadingClassLoader != null) {
            classPool.appendClassPath((ClassPath)new LoaderClassPath(loadingClassLoader));
        }
        return classPool;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected CtClass loadCtClassFromClass(Class<?> aClass) {
        CtClass ctClass;
        String resourceName = String.valueOf(aClass.getName().replace('.', '/')) + ".class";
        InputStream resourceAsStream = aClass.getClassLoader().getResourceAsStream(resourceName);
        if (resourceAsStream == null) {
            throw new UncheckedIOException(new FileNotFoundException("Not found: " + resourceName));
        }
        try {
            ctClass = this.classPool.makeClass(resourceAsStream);
        }
        catch (IOException e) {
            try {
                throw new EnhancementException("Could not prepare Javassist ClassPool", e);
            }
            catch (Throwable throwable) {
                try {
                    resourceAsStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    log.debugf("An error occurs closing InputStream for class [%s]", aClass.getName());
                }
                throw throwable;
            }
        }
        try {
            resourceAsStream.close();
            return ctClass;
        }
        catch (IOException iOException) {
            log.debugf("An error occurs closing InputStream for class [%s]", aClass.getName());
        }
        return ctClass;
    }

    private boolean enhance(CtClass managedCtClass) {
        if (managedCtClass.isInterface()) {
            log.debugf("Skipping enhancement of [%s]: it's an interface!", managedCtClass.getName());
            return false;
        }
        if (this.alreadyEnhanced(managedCtClass)) {
            log.debugf("Skipping enhancement of [%s]: already enhanced", managedCtClass.getName());
            return false;
        }
        if (this.enhancementContext.isEntityClass(managedCtClass)) {
            log.debugf("Enhancing [%s] as Entity", managedCtClass.getName());
            new EntityEnhancer(this.enhancementContext).enhance(managedCtClass);
            return true;
        }
        if (this.enhancementContext.isCompositeClass(managedCtClass)) {
            log.debugf("Enhancing [%s] as Composite", managedCtClass.getName());
            new CompositeEnhancer(this.enhancementContext).enhance(managedCtClass);
            return true;
        }
        if (this.enhancementContext.isMappedSuperclassClass(managedCtClass)) {
            log.debugf("Enhancing [%s] as MappedSuperclass", managedCtClass.getName());
            new MappedSuperclassEnhancer(this.enhancementContext).enhance(managedCtClass);
            return true;
        }
        if (this.enhancementContext.doExtendedEnhancement(managedCtClass)) {
            log.debugf("Extended enhancement of [%s]", managedCtClass.getName());
            new PersistentAttributesEnhancer(this.enhancementContext).extendedEnhancement(managedCtClass);
            return true;
        }
        log.debugf("Skipping enhancement of [%s]: not entity or composite", managedCtClass.getName());
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean alreadyEnhanced(CtClass managedCtClass) {
        try {
            CtClass[] ctClassArray = managedCtClass.getInterfaces();
            int n = ctClassArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                CtClass declaredInterface = ctClassArray[n2];
                if (PersistentAttributesHelper.isAssignable(declaredInterface, Managed.class.getName())) {
                    return true;
                }
                ++n2;
            }
        }
        catch (NotFoundException e) {
            throw new HibernateException("Unable to transform class: " + e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] getByteCode(CtClass managedCtClass) {
        byte[] byArray;
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteStream);
        try {
            managedCtClass.toBytecode(out);
            byArray = byteStream.toByteArray();
        }
        catch (Exception e) {
            try {
                log.unableToTransformClass(e.getMessage());
                throw new HibernateException("Unable to transform class: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                try {
                    out.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            out.close();
            return byArray;
        }
        catch (IOException iOException) {}
        return byArray;
    }

    protected void addInterceptorHandling(CtClass managedCtClass) {
        if (!this.enhancementContext.hasLazyLoadableAttributes(managedCtClass)) {
            return;
        }
        log.debugf("Weaving in PersistentAttributeInterceptable implementation on [%s]", managedCtClass.getName());
        managedCtClass.addInterface(this.loadCtClassFromClass(PersistentAttributeInterceptable.class));
        FieldWriter.addFieldWithGetterAndSetter(managedCtClass, this.loadCtClassFromClass(PersistentAttributeInterceptor.class), "$$_hibernate_attributeInterceptor", "$$_hibernate_getInterceptor", "$$_hibernate_setInterceptor");
    }
}

