/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.Ejb3JoinColumn;
import org.hibernate.cfg.SecondPass;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.jboss.logging.Logger;

public class CopyIdentifierComponentSecondPass
implements SecondPass {
    private static final Logger log = Logger.getLogger(CopyIdentifierComponentSecondPass.class);
    private final String referencedEntityName;
    private final Component component;
    private final MetadataBuildingContext buildingContext;
    private final Ejb3JoinColumn[] joinColumns;

    public CopyIdentifierComponentSecondPass(Component comp, String referencedEntityName, Ejb3JoinColumn[] joinColumns, MetadataBuildingContext buildingContext) {
        this.component = comp;
        this.referencedEntityName = referencedEntityName;
        this.buildingContext = buildingContext;
        this.joinColumns = joinColumns;
    }

    @Override
    public void doSecondPass(Map persistentClasses) throws MappingException {
        PersistentClass referencedPersistentClass = (PersistentClass)persistentClasses.get(this.referencedEntityName);
        if (referencedPersistentClass == null) {
            throw new AnnotationException("Unknown entity name: " + this.referencedEntityName);
        }
        if (!(referencedPersistentClass.getIdentifier() instanceof Component)) {
            throw new AssertionFailure("Unexpected identifier type on the referenced entity when mapping a @MapsId: " + this.referencedEntityName);
        }
        Component referencedComponent = (Component)referencedPersistentClass.getIdentifier();
        Iterator properties = referencedComponent.getPropertyIterator();
        boolean isExplicitReference = true;
        HashMap<String, Ejb3JoinColumn> columnByReferencedName = new HashMap<String, Ejb3JoinColumn>(this.joinColumns.length);
        Ejb3JoinColumn[] ejb3JoinColumnArray = this.joinColumns;
        int n = this.joinColumns.length;
        int n2 = 0;
        while (n2 < n) {
            Ejb3JoinColumn joinColumn = ejb3JoinColumnArray[n2];
            String referencedColumnName = joinColumn.getReferencedColumn();
            if (referencedColumnName == null || BinderHelper.isEmptyAnnotationValue(referencedColumnName)) break;
            columnByReferencedName.put(referencedColumnName.toLowerCase(Locale.ROOT), joinColumn);
            ++n2;
        }
        AtomicInteger index = new AtomicInteger(0);
        if (columnByReferencedName.isEmpty()) {
            isExplicitReference = false;
            Ejb3JoinColumn[] ejb3JoinColumnArray2 = this.joinColumns;
            int n3 = this.joinColumns.length;
            n = 0;
            while (n < n3) {
                Ejb3JoinColumn joinColumn = ejb3JoinColumnArray2[n];
                columnByReferencedName.put(String.valueOf(index.get()), joinColumn);
                index.getAndIncrement();
                ++n;
            }
            index.set(0);
        }
        while (properties.hasNext()) {
            Property referencedProperty = (Property)properties.next();
            if (referencedProperty.isComposite()) {
                Property property = this.createComponentProperty(referencedPersistentClass, isExplicitReference, columnByReferencedName, index, referencedProperty);
                this.component.addProperty(property);
                continue;
            }
            Property property = this.createSimpleProperty(referencedPersistentClass, isExplicitReference, columnByReferencedName, index, referencedProperty);
            this.component.addProperty(property);
        }
    }

    private Property createComponentProperty(PersistentClass referencedPersistentClass, boolean isExplicitReference, Map<String, Ejb3JoinColumn> columnByReferencedName, AtomicInteger index, Property referencedProperty) {
        Property property = new Property();
        property.setName(referencedProperty.getName());
        property.setPersistentClass(this.component.getOwner());
        property.setPropertyAccessorName(referencedProperty.getPropertyAccessorName());
        Component value = new Component(this.buildingContext, this.component.getOwner());
        property.setValue(value);
        Component referencedValue = (Component)referencedProperty.getValue();
        value.setTypeName(referencedValue.getTypeName());
        value.setTypeParameters(referencedValue.getTypeParameters());
        value.setComponentClassName(referencedValue.getComponentClassName());
        Iterator propertyIterator = referencedValue.getPropertyIterator();
        while (propertyIterator.hasNext()) {
            Property componentProperty;
            Property referencedComponentProperty = (Property)propertyIterator.next();
            if (referencedComponentProperty.isComposite()) {
                componentProperty = this.createComponentProperty(referencedValue.getOwner(), isExplicitReference, columnByReferencedName, index, referencedComponentProperty);
                value.addProperty(componentProperty);
                continue;
            }
            componentProperty = this.createSimpleProperty(referencedValue.getOwner(), isExplicitReference, columnByReferencedName, index, referencedComponentProperty);
            value.addProperty(componentProperty);
        }
        return property;
    }

    /*
     * Unable to fully structure code
     */
    private Property createSimpleProperty(PersistentClass referencedPersistentClass, boolean isExplicitReference, Map<String, Ejb3JoinColumn> columnByReferencedName, AtomicInteger index, Property referencedProperty) {
        block6: {
            property = new Property();
            property.setName(referencedProperty.getName());
            property.setPersistentClass(this.component.getOwner());
            property.setPropertyAccessorName(referencedProperty.getPropertyAccessorName());
            value = new SimpleValue(this.buildingContext, this.component.getTable());
            property.setValue(value);
            referencedValue = (SimpleValue)referencedProperty.getValue();
            value.setTypeName(referencedValue.getTypeName());
            value.setTypeParameters(referencedValue.getTypeParameters());
            columns = referencedValue.getColumnIterator();
            if (!this.joinColumns[0].isNameDeferred()) ** GOTO lbl36
            this.joinColumns[0].copyReferencedStructureAndCreateDefaultJoinColumns(referencedPersistentClass, columns, value);
            break block6;
lbl-1000:
            // 1 sources

            {
                selectable = columns.next();
                if (!Column.class.isInstance(selectable)) {
                    CopyIdentifierComponentSecondPass.log.debug((Object)"Encountered formula definition; skipping");
                    continue;
                }
                column = (Column)selectable;
                logicalColumnName = null;
                if (isExplicitReference) {
                    columnName = column.getName();
                    logicalColumnName = this.buildingContext.getMetadataCollector().getLogicalColumnName(referencedPersistentClass.getTable(), columnName);
                    joinColumn = columnByReferencedName.get(logicalColumnName.toLowerCase(Locale.ROOT));
                } else {
                    joinColumn = columnByReferencedName.get(String.valueOf(index.get()));
                    index.getAndIncrement();
                }
                if (joinColumn == null && !this.joinColumns[0].isNameDeferred()) {
                    throw new AnnotationException(isExplicitReference != false ? "Unable to find column reference in the @MapsId mapping: " + logicalColumnName : "Implicit column reference in the @MapsId mapping fails, try to use explicit referenceColumnNames: " + this.referencedEntityName);
                }
                columnName = joinColumn == null || joinColumn.isNameDeferred() != false ? "tata_" + column.getName() : joinColumn.getName();
                value.addColumn(new Column(columnName));
                if (joinColumn != null) {
                    this.applyComponentColumnSizeValueToJoinColumn(column, joinColumn);
                    joinColumn.linkWithValue(value);
                }
                column.setValue(value);
lbl36:
                // 3 sources

                ** while (columns.hasNext())
            }
        }
        return property;
    }

    private void applyComponentColumnSizeValueToJoinColumn(Column column, Ejb3JoinColumn joinColumn) {
        Column mappingColumn = joinColumn.getMappingColumn();
        mappingColumn.setLength(column.getLength());
        mappingColumn.setPrecision(column.getPrecision());
        mappingColumn.setScale(column.getScale());
    }

    public boolean dependentUpon(CopyIdentifierComponentSecondPass other) {
        return this.referencedEntityName.equals(other.component.getOwner().getEntityName());
    }
}

